/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jmx;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.jmx.DefaultMBeanAttributeFilter;
import org.springframework.integration.jmx.MBeanAttributeFilter;
import org.springframework.integration.jmx.MBeanObjectConverter;

public class DefaultMBeanObjectConverter
implements MBeanObjectConverter {
    private static final Log log = LogFactory.getLog(DefaultMBeanObjectConverter.class);
    private final MBeanAttributeFilter filter;

    public DefaultMBeanObjectConverter() {
        this(new DefaultMBeanAttributeFilter());
    }

    public DefaultMBeanObjectConverter(MBeanAttributeFilter filter) {
        this.filter = filter;
    }

    @Override
    public Object convert(MBeanServerConnection connection, ObjectInstance instance) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        try {
            MBeanAttributeInfo[] attributeInfos;
            ObjectName objName = instance.getObjectName();
            if (!connection.isRegistered(objName)) {
                return attributeMap;
            }
            MBeanInfo info = connection.getMBeanInfo(objName);
            for (MBeanAttributeInfo attrInfo : attributeInfos = info.getAttributes()) {
                Object value;
                if ("ObjectName".equals(attrInfo.getName()) || !this.filter.accept(objName, attrInfo.getName())) continue;
                try {
                    value = connection.getAttribute(objName, attrInfo.getName());
                }
                catch (RuntimeMBeanException e) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Error getting attribute '" + attrInfo.getName() + "' on '" + objName + "'"), (Throwable)e);
                    }
                    Throwable t = e;
                    while (t.getCause() != null) {
                        t = t.getCause();
                    }
                    value = String.format("%s[%s]", t.getClass().getName(), t.getMessage());
                }
                attributeMap.put(attrInfo.getName(), this.checkAndConvert(value));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return attributeMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object checkAndConvert(Object input) {
        TabularData data;
        if (input == null) {
            return input;
        }
        if (input.getClass().isArray()) {
            if (!CompositeData.class.isAssignableFrom(input.getClass().getComponentType())) {
                if (!TabularData.class.isAssignableFrom(input.getClass().getComponentType())) return input;
                log.warn((Object)("TabularData.isAssignableFrom(getComponentType) for " + input.toString()));
                return input;
            }
            ArrayList<Object> converted = new ArrayList<Object>();
            int length = Array.getLength(input);
            int i = 0;
            while (i < length) {
                Object value = this.checkAndConvert(Array.get(input, i));
                converted.add(value);
                ++i;
            }
            return converted;
        }
        if (!(input instanceof CompositeData)) {
            if (!(input instanceof TabularData)) return input;
            data = (TabularData)input;
            if (data.getTabularType().isArray()) {
                log.warn((Object)("TabularData.isArray for " + input.toString()));
                return input;
            }
        } else {
            CompositeData data2 = (CompositeData)input;
            if (data2.getCompositeType().isArray()) {
                log.warn((Object)("(data.getCompositeType().isArray for " + input.toString()));
                return input;
            }
            HashMap<String, Object> returnable = new HashMap<String, Object>();
            Set<String> keys = data2.getCompositeType().keySet();
            Iterator<String> i$ = keys.iterator();
            while (i$.hasNext()) {
                String key = i$.next();
                if ("ObjectName".equals(key)) continue;
                Object value = this.checkAndConvert(data2.get(key));
                returnable.put(key, value);
            }
            return returnable;
        }
        HashMap<Object, Object> returnable = new HashMap<Object, Object>();
        Set<?> keySet = data.keySet();
        Iterator<?> i$ = keySet.iterator();
        while (i$.hasNext()) {
            List keys = (List)i$.next();
            CompositeData cd = data.get(keys.toArray());
            Object value = this.checkAndConvert(cd);
            if (keys.size() == 1 && value instanceof Map && ((Map)value).size() == 2) {
                Object actualKey = keys.get(0);
                Map valueMap = (Map)value;
                if (valueMap.containsKey("key") && valueMap.containsKey("value") && actualKey.equals(valueMap.get("key"))) {
                    returnable.put(valueMap.get("key"), valueMap.get("value"));
                    continue;
                }
                returnable.put(actualKey, value);
                continue;
            }
            returnable.put(keys, value);
        }
        return returnable;
    }
}

