/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.monitor;

import org.springframework.integration.monitor.Statistics;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.support.MetricType;

public interface MessageChannelMetrics {
    @ManagedOperation
    public void reset();

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="MessageChannel Send Count")
    public int getSendCount();

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="MessageChannel Send Error Count")
    public int getSendErrorCount();

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Channel Time Since Last Send in Seconds")
    public double getTimeSinceLastSend();

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Channel Send Rate per Second")
    public double getMeanSendRate();

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Channel Error Rate per Second")
    public double getMeanErrorRate();

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Mean Channel Error Ratio per Minute")
    public double getMeanErrorRatio();

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Channel Send Mean Duration in Milliseconds")
    public double getMeanSendDuration();

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Channel Send Min Duration in Milliseconds")
    public double getMinSendDuration();

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Channel Send Max Duration in Milliseconds")
    public double getMaxSendDuration();

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Channel Send Standard Deviation Duration in Milliseconds")
    public double getStandardDeviationSendDuration();

    public Statistics getSendDuration();

    public Statistics getSendRate();

    public Statistics getErrorRate();
}

