/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.dsl;

import java.util.Collections;
import java.util.Map;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageSourceSpec;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.jpa.core.JpaExecutor;
import org.springframework.integration.jpa.inbound.JpaPollingChannelAdapter;
import org.springframework.integration.jpa.support.parametersource.ParameterSource;

public class JpaInboundChannelAdapterSpec
extends MessageSourceSpec<JpaInboundChannelAdapterSpec, JpaPollingChannelAdapter>
implements ComponentsRegistration {
    protected final JpaExecutor jpaExecutor;

    protected JpaInboundChannelAdapterSpec(JpaExecutor jpaExecutor) {
        this.jpaExecutor = jpaExecutor;
        this.target = new JpaPollingChannelAdapter(this.jpaExecutor);
    }

    public JpaInboundChannelAdapterSpec entityClass(Class<?> entityClass) {
        this.jpaExecutor.setEntityClass(entityClass);
        return this;
    }

    public JpaInboundChannelAdapterSpec jpaQuery(String jpaQuery) {
        this.jpaExecutor.setJpaQuery(jpaQuery);
        return this;
    }

    public JpaInboundChannelAdapterSpec nativeQuery(String nativeQuery) {
        this.jpaExecutor.setNativeQuery(nativeQuery);
        return this;
    }

    public JpaInboundChannelAdapterSpec namedQuery(String namedQuery) {
        this.jpaExecutor.setNamedQuery(namedQuery);
        return this;
    }

    public JpaInboundChannelAdapterSpec deleteAfterPoll(boolean deleteAfterPoll) {
        this.jpaExecutor.setDeleteAfterPoll(deleteAfterPoll);
        return this;
    }

    public JpaInboundChannelAdapterSpec deleteInBatch(boolean deleteInBatch) {
        this.jpaExecutor.setDeleteInBatch(deleteInBatch);
        return this;
    }

    public JpaInboundChannelAdapterSpec flushAfterDelete(boolean flush) {
        this.jpaExecutor.setFlush(flush);
        return this;
    }

    public JpaInboundChannelAdapterSpec parameterSource(ParameterSource parameterSource) {
        this.jpaExecutor.setParameterSource(parameterSource);
        return this;
    }

    public JpaInboundChannelAdapterSpec expectSingleResult(boolean expectSingleResult) {
        this.jpaExecutor.setExpectSingleResult(expectSingleResult);
        return this;
    }

    public JpaInboundChannelAdapterSpec maxResults(int maxResults) {
        return this.maxResultsExpression((Expression)new ValueExpression((Object)maxResults));
    }

    public JpaInboundChannelAdapterSpec maxResultsExpression(String maxResultsExpression) {
        return this.maxResultsExpression(PARSER.parseExpression(maxResultsExpression));
    }

    public JpaInboundChannelAdapterSpec maxResultsExpression(Expression maxResultsExpression) {
        this.jpaExecutor.setMaxResultsExpression(maxResultsExpression);
        return this;
    }

    public Map<Object, String> getComponentsToRegister() {
        return Collections.singletonMap(this.jpaExecutor, null);
    }
}

