/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.mail.MailReceivingMessageSource;
import org.springframework.integration.mail.config.MailReceiverFactoryBean;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class MailInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MailReceivingMessageSource.class);
        builder.addConstructorArgValue((Object)this.parseMailReceiver(element, parserContext));
        return builder.getBeanDefinition();
    }

    private BeanDefinition parseMailReceiver(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder receiverBuilder = BeanDefinitionBuilder.genericBeanDefinition(MailReceiverFactoryBean.class);
        Object source = parserContext.extractSource((Object)element);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"store-uri");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"protocol");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"search-term-strategy");
        String session = element.getAttribute("session");
        if (StringUtils.hasText((String)session)) {
            if (element.hasAttribute("java-mail-properties") || element.hasAttribute("authenticator")) {
                parserContext.getReaderContext().error("Neither 'java-mail-properties' nor 'authenticator' references are allowed when a 'session' reference has been provided.", source);
            }
            receiverBuilder.addPropertyReference("session", session);
        } else {
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"java-mail-properties");
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"authenticator");
        }
        String maxFetchSize = element.getAttribute("max-fetch-size");
        if (StringUtils.hasText((String)maxFetchSize)) {
            receiverBuilder.addPropertyValue("maxFetchSize", (Object)maxFetchSize);
        } else {
            String mmpp;
            Element pollerElement = DomUtils.getChildElementByTagName((Element)element, (String)"poller");
            if (pollerElement != null && StringUtils.hasText((String)(mmpp = pollerElement.getAttribute("max-messages-per-poll")))) {
                receiverBuilder.addPropertyValue("maxFetchSize", (Object)mmpp);
            }
        }
        receiverBuilder.addPropertyValue("shouldDeleteMessages", (Object)element.getAttribute("should-delete-messages"));
        String markAsRead = element.getAttribute("should-mark-messages-as-read");
        if (StringUtils.hasText((String)markAsRead)) {
            receiverBuilder.addPropertyValue("shouldMarkMessagesAsRead", (Object)markAsRead);
        }
        String selectorExpression = element.getAttribute("mail-filter-expression");
        RootBeanDefinition expressionDef = null;
        if (StringUtils.hasText((String)selectorExpression)) {
            expressionDef = new RootBeanDefinition("org.springframework.integration.config.ExpressionFactoryBean");
            expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)selectorExpression);
            receiverBuilder.addPropertyValue("selectorExpression", (Object)expressionDef);
        }
        return receiverBuilder.getBeanDefinition();
    }
}

