/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import java.util.Date;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import javax.mail.Folder;
import javax.mail.Message;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mail.ImapMailReceiver;
import org.springframework.integration.mail.event.MailIntegrationEvent;
import org.springframework.integration.transaction.IntegrationResourceHolder;
import org.springframework.integration.transaction.IntegrationResourceHolderSynchronization;
import org.springframework.integration.transaction.TransactionSynchronizationFactory;
import org.springframework.messaging.MessagingException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ImapIdleChannelAdapter
extends MessageProducerSupport
implements BeanClassLoaderAware,
ApplicationEventPublisherAware {
    private static final int DEFAULT_RECONNECT_DELAY = 10000;
    private final ExceptionAwarePeriodicTrigger receivingTaskTrigger = new ExceptionAwarePeriodicTrigger();
    private final IdleTask idleTask = new IdleTask();
    private final ImapMailReceiver mailReceiver;
    private TransactionSynchronizationFactory transactionSynchronizationFactory;
    private ClassLoader classLoader;
    private ApplicationEventPublisher applicationEventPublisher;
    private boolean shouldReconnectAutomatically = true;
    private Executor sendingTaskExecutor;
    private boolean sendingTaskExecutorSet;
    private List<Advice> adviceChain;
    private long reconnectDelay = 10000L;
    private volatile ScheduledFuture<?> receivingTask;

    public ImapIdleChannelAdapter(ImapMailReceiver mailReceiver) {
        Assert.notNull((Object)mailReceiver, (String)"'mailReceiver' must not be null");
        this.mailReceiver = mailReceiver;
    }

    public void setTransactionSynchronizationFactory(TransactionSynchronizationFactory transactionSynchronizationFactory) {
        this.transactionSynchronizationFactory = transactionSynchronizationFactory;
    }

    public void setAdviceChain(List<Advice> adviceChain) {
        this.adviceChain = adviceChain;
    }

    public void setSendingTaskExecutor(Executor sendingTaskExecutor) {
        Assert.notNull((Object)sendingTaskExecutor, (String)"'sendingTaskExecutor' must not be null");
        this.sendingTaskExecutor = sendingTaskExecutor;
        this.sendingTaskExecutorSet = true;
    }

    public void setShouldReconnectAutomatically(boolean shouldReconnectAutomatically) {
        this.shouldReconnectAutomatically = shouldReconnectAutomatically;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public String getComponentType() {
        return "mail:imap-idle-channel-adapter";
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected void doStart() {
        TaskScheduler scheduler = this.getTaskScheduler();
        Assert.notNull((Object)scheduler, (String)"'taskScheduler' must not be null");
        if (this.sendingTaskExecutor == null) {
            this.sendingTaskExecutor = Executors.newFixedThreadPool(1);
        }
        this.receivingTask = scheduler.schedule((Runnable)new ReceivingTask(), (Trigger)this.receivingTaskTrigger);
    }

    protected void doStop() {
        this.receivingTask.cancel(true);
        try {
            this.mailReceiver.destroy();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failure during the destruction of Mail receiver: " + this.mailReceiver, e);
        }
        if (!this.sendingTaskExecutorSet && this.sendingTaskExecutor != null) {
            ((ExecutorService)this.sendingTaskExecutor).shutdown();
            this.sendingTaskExecutor = null;
        }
    }

    private Runnable createMessageSendingTask(Object mailMessage) {
        Runnable sendingTask = () -> {
            TransactionSynchronization synchronization;
            org.springframework.messaging.Message message;
            org.springframework.messaging.Message message2 = message = mailMessage instanceof Message ? this.getMessageBuilderFactory().withPayload(mailMessage).build() : (org.springframework.messaging.Message)mailMessage;
            if (TransactionSynchronizationManager.isActualTransactionActive() && this.transactionSynchronizationFactory != null && (synchronization = this.transactionSynchronizationFactory.create((Object)this)) != null) {
                Object resourceHolder;
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)synchronization);
                if (synchronization instanceof IntegrationResourceHolderSynchronization && !TransactionSynchronizationManager.hasResource((Object)((Object)this))) {
                    TransactionSynchronizationManager.bindResource((Object)((Object)this), (Object)((IntegrationResourceHolderSynchronization)synchronization).getResourceHolder());
                }
                if ((resourceHolder = TransactionSynchronizationManager.getResource((Object)((Object)this))) instanceof IntegrationResourceHolder) {
                    ((IntegrationResourceHolder)resourceHolder).setMessage(message);
                }
            }
            this.sendMessage(message);
        };
        if (!CollectionUtils.isEmpty(this.adviceChain)) {
            ProxyFactory proxyFactory = new ProxyFactory((Object)sendingTask);
            if (!CollectionUtils.isEmpty(this.adviceChain)) {
                for (Advice advice : this.adviceChain) {
                    proxyFactory.addAdvice(advice);
                }
            }
            sendingTask = (Runnable)proxyFactory.getProxy(this.classLoader);
        }
        return sendingTask;
    }

    private void publishException(Exception e) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ImapIdleExceptionEvent(e));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No application event publisher for exception: " + e.getMessage()));
        }
    }

    public class ImapIdleExceptionEvent
    extends MailIntegrationEvent {
        private static final long serialVersionUID = -5875388810251967741L;

        ImapIdleExceptionEvent(Exception e) {
            super((Object)ImapIdleChannelAdapter.this, e);
        }
    }

    private class ExceptionAwarePeriodicTrigger
    implements Trigger {
        private volatile boolean delayNextExecution;

        ExceptionAwarePeriodicTrigger() {
        }

        public Date nextExecutionTime(TriggerContext triggerContext) {
            if (this.delayNextExecution) {
                this.delayNextExecution = false;
                return new Date(System.currentTimeMillis() + ImapIdleChannelAdapter.this.reconnectDelay);
            }
            return new Date(System.currentTimeMillis());
        }

        void delayNextExecution() {
            this.delayNextExecution = true;
        }
    }

    private class IdleTask
    implements Runnable {
        IdleTask() {
        }

        @Override
        public void run() {
            TaskScheduler scheduler = ImapIdleChannelAdapter.this.getTaskScheduler();
            Assert.notNull((Object)scheduler, (String)"'taskScheduler' must not be null");
            Assert.state((ImapIdleChannelAdapter.this.sendingTaskExecutor != null ? 1 : 0) != 0, (String)"'sendingTaskExecutor' must not be null");
            try {
                ImapIdleChannelAdapter.this.logger.debug((Object)"waiting for mail");
                ImapIdleChannelAdapter.this.mailReceiver.waitForNewMessages();
                Folder folder = ImapIdleChannelAdapter.this.mailReceiver.getFolder();
                if (folder != null && folder.isOpen()) {
                    Object[] mailMessages = ImapIdleChannelAdapter.this.mailReceiver.receive();
                    if (ImapIdleChannelAdapter.this.logger.isDebugEnabled()) {
                        ImapIdleChannelAdapter.this.logger.debug((Object)("received " + mailMessages.length + " mail messages"));
                    }
                    for (Object mailMessage : mailMessages) {
                        Runnable messageSendingTask = ImapIdleChannelAdapter.this.createMessageSendingTask(mailMessage);
                        ImapIdleChannelAdapter.this.sendingTaskExecutor.execute(messageSendingTask);
                    }
                }
            }
            catch (javax.mail.MessagingException e) {
                ImapIdleChannelAdapter.this.logger.warn((Object)"error occurred in idle task", (Throwable)e);
                if (ImapIdleChannelAdapter.this.shouldReconnectAutomatically) {
                    throw new IllegalStateException("Failure in 'idle' task. Will resubmit.", e);
                }
                throw new MessagingException("Failure in 'idle' task. Will NOT resubmit.", (Throwable)e);
            }
        }
    }

    private class ReceivingTask
    implements Runnable {
        ReceivingTask() {
        }

        @Override
        public void run() {
            try {
                ImapIdleChannelAdapter.this.idleTask.run();
                ImapIdleChannelAdapter.this.logger.debug((Object)"Task completed successfully. Re-scheduling it again right away.");
            }
            catch (Exception e) {
                if (ImapIdleChannelAdapter.this.logger.isWarnEnabled()) {
                    ImapIdleChannelAdapter.this.logger.warn((Object)("Failed to execute IDLE task. Will attempt to resubmit in " + ImapIdleChannelAdapter.this.reconnectDelay + " milliseconds."), (Throwable)e);
                }
                ImapIdleChannelAdapter.this.receivingTaskTrigger.delayNextExecution();
                ImapIdleChannelAdapter.this.publishException(e);
            }
        }
    }
}

