/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import com.sun.mail.imap.IMAPFolder;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ScheduledFuture;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.event.MessageCountAdapter;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.search.AndTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.SearchTerm;
import org.springframework.integration.mail.AbstractMailReceiver;
import org.springframework.integration.mail.SearchTermStrategy;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;

public class ImapMailReceiver
extends AbstractMailReceiver {
    private static final int DEFAULT_CANCEL_IDLE_INTERVAL = 120000;
    private final MessageCountListener messageCountListener = new SimpleMessageCountListener();
    private final IdleCanceler idleCanceler = new IdleCanceler();
    private boolean shouldMarkMessagesAsRead = true;
    private SearchTermStrategy searchTermStrategy = new DefaultSearchTermStrategy();
    private long cancelIdleInterval = 120000L;
    private TaskScheduler scheduler;
    private boolean isInternalScheduler;
    private volatile ScheduledFuture<?> pingTask;

    public ImapMailReceiver() {
        this.setProtocol("imap");
    }

    public ImapMailReceiver(String url) {
        super(url);
        if (url != null) {
            Assert.isTrue((boolean)url.toLowerCase().startsWith("imap"), (String)"URL must start with 'imap' for the IMAP Mail receiver.");
        } else {
            this.setProtocol("imap");
        }
    }

    public Boolean isShouldMarkMessagesAsRead() {
        return this.shouldMarkMessagesAsRead;
    }

    public void setSearchTermStrategy(SearchTermStrategy searchTermStrategy) {
        Assert.notNull((Object)searchTermStrategy, (String)"'searchTermStrategy' must not be null");
        this.searchTermStrategy = searchTermStrategy;
    }

    public void setShouldMarkMessagesAsRead(Boolean shouldMarkMessagesAsRead) {
        this.shouldMarkMessagesAsRead = shouldMarkMessagesAsRead;
    }

    public void setCancelIdleInterval(long cancelIdleInterval) {
        this.cancelIdleInterval = cancelIdleInterval * 1000L;
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.scheduler = this.getTaskScheduler();
        if (this.scheduler == null) {
            ThreadPoolTaskScheduler tpts = new ThreadPoolTaskScheduler();
            tpts.initialize();
            this.scheduler = tpts;
            this.isInternalScheduler = true;
        }
        Properties javaMailProperties = this.getJavaMailProperties();
        for (String name : new String[]{"imap", "imaps"}) {
            String peek = "mail." + name + ".peek";
            if (javaMailProperties.getProperty(peek) != null) continue;
            javaMailProperties.setProperty(peek, "true");
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.isInternalScheduler) {
            ((ThreadPoolTaskScheduler)this.scheduler).shutdown();
        }
    }

    public void waitForNewMessages() throws MessagingException {
        this.openFolder();
        Folder folder = this.getFolder();
        Assert.state((boolean)(folder instanceof IMAPFolder), (String)("folder is not an instance of [" + IMAPFolder.class.getName() + "]"));
        IMAPFolder imapFolder = (IMAPFolder)folder;
        if (imapFolder.hasNewMessages()) {
            return;
        }
        if (!folder.getPermanentFlags().contains(Flags.Flag.RECENT) && this.searchForNewMessages().length > 0) {
            return;
        }
        imapFolder.addMessageCountListener(this.messageCountListener);
        try {
            this.pingTask = this.scheduler.schedule((Runnable)this.idleCanceler, new Date(System.currentTimeMillis() + this.cancelIdleInterval));
            if (imapFolder.isOpen()) {
                imapFolder.idle();
            }
        }
        finally {
            imapFolder.removeMessageCountListener(this.messageCountListener);
            if (this.pingTask != null) {
                this.pingTask.cancel(true);
            }
        }
    }

    @Override
    protected Message[] searchForNewMessages() throws MessagingException {
        Flags supportedFlags = this.getFolder().getPermanentFlags();
        SearchTerm searchTerm = this.compileSearchTerms(supportedFlags);
        Folder folder = this.getFolder();
        if (folder.isOpen()) {
            return this.nullSafeMessages(searchTerm != null ? folder.search(searchTerm) : folder.getMessages());
        }
        throw new MessagingException("Folder is closed");
    }

    private Message[] nullSafeMessages(Message[] messageArray) {
        boolean hasNulls = false;
        for (Message message : messageArray) {
            if (message != null) continue;
            hasNulls = true;
            break;
        }
        if (!hasNulls) {
            return messageArray;
        }
        return (Message[])Arrays.stream(messageArray).filter(Objects::nonNull).toArray(Message[]::new);
    }

    private SearchTerm compileSearchTerms(Flags supportedFlags) {
        return this.searchTermStrategy.generateSearchTerm(supportedFlags, this.getFolder());
    }

    @Override
    protected void setAdditionalFlags(Message message) throws MessagingException {
        super.setAdditionalFlags(message);
        if (this.shouldMarkMessagesAsRead) {
            message.setFlag(Flags.Flag.SEEN, true);
        }
    }

    private class DefaultSearchTermStrategy
    implements SearchTermStrategy {
        DefaultSearchTermStrategy() {
        }

        @Override
        public SearchTerm generateSearchTerm(Flags supportedFlags, Folder folder) {
            Object searchTerm = null;
            boolean recentFlagSupported = false;
            if (supportedFlags != null) {
                recentFlagSupported = supportedFlags.contains(Flags.Flag.RECENT);
                if (recentFlagSupported) {
                    searchTerm = new FlagTerm(new Flags(Flags.Flag.RECENT), true);
                }
                if (supportedFlags.contains(Flags.Flag.ANSWERED)) {
                    NotTerm notAnswered = new NotTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.ANSWERED), true));
                    searchTerm = searchTerm == null ? notAnswered : new AndTerm((SearchTerm)searchTerm, (SearchTerm)notAnswered);
                }
                if (supportedFlags.contains(Flags.Flag.DELETED)) {
                    NotTerm notDeleted = new NotTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.DELETED), true));
                    searchTerm = searchTerm == null ? notDeleted : new AndTerm((SearchTerm)searchTerm, (SearchTerm)notDeleted);
                }
                if (supportedFlags.contains(Flags.Flag.SEEN)) {
                    NotTerm notSeen = new NotTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), true));
                    searchTerm = searchTerm == null ? notSeen : new AndTerm((SearchTerm)searchTerm, (SearchTerm)notSeen);
                }
            }
            if (!recentFlagSupported) {
                NotTerm notFlagged = null;
                if (folder.getPermanentFlags().contains(Flags.Flag.USER)) {
                    ImapMailReceiver.this.logger.debug((Object)("This email server does not support RECENT flag, but it does support USER flags which will be used to prevent duplicates during email fetch. This receiver instance uses flag: " + ImapMailReceiver.this.getUserFlag()));
                    Flags siFlags = new Flags();
                    siFlags.add(ImapMailReceiver.this.getUserFlag());
                    notFlagged = new NotTerm((SearchTerm)new FlagTerm(siFlags, true));
                } else {
                    ImapMailReceiver.this.logger.debug((Object)"This email server does not support RECENT or USER flags. System flag 'Flag.FLAGGED' will be used to prevent duplicates during email fetch.");
                    notFlagged = new NotTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.FLAGGED), true));
                }
                searchTerm = searchTerm == null ? notFlagged : new AndTerm((SearchTerm)searchTerm, (SearchTerm)notFlagged);
            }
            return searchTerm;
        }
    }

    private static class SimpleMessageCountListener
    extends MessageCountAdapter {
        SimpleMessageCountListener() {
        }

        public void messagesAdded(MessageCountEvent event) {
            Message[] messages = event.getMessages();
            if (messages.length > 0) {
                messages[0].getFolder().isOpen();
            }
        }
    }

    private class IdleCanceler
    implements Runnable {
        IdleCanceler() {
        }

        @Override
        public void run() {
            try {
                Folder folder = ImapMailReceiver.this.getFolder();
                ImapMailReceiver.this.logger.debug((Object)"Canceling IDLE");
                if (folder != null) {
                    folder.isOpen();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

