/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.dsl;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageSourceSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.mail.AbstractMailReceiver;
import org.springframework.integration.mail.MailReceiver;
import org.springframework.integration.mail.MailReceivingMessageSource;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.PropertiesBuilder;
import org.springframework.util.Assert;

public abstract class MailInboundChannelAdapterSpec<S extends MailInboundChannelAdapterSpec<S, R>, R extends AbstractMailReceiver>
extends MessageSourceSpec<S, MailReceivingMessageSource>
implements ComponentsRegistration {
    protected final R receiver;
    protected final boolean externalReceiver;
    private boolean sessionProvided;

    protected MailInboundChannelAdapterSpec(R receiver) {
        this(receiver, false);
    }

    protected MailInboundChannelAdapterSpec(R receiver, boolean externalReceiver) {
        this.receiver = receiver;
        this.externalReceiver = externalReceiver;
    }

    public S selectorExpression(String selectorExpression) {
        this.assertReceiver();
        ((AbstractMailReceiver)this.receiver).setSelectorExpression(PARSER.parseExpression(selectorExpression));
        return (S)((Object)((MailInboundChannelAdapterSpec)this._this()));
    }

    protected void assertReceiver() {
        Assert.state((!this.externalReceiver ? 1 : 0) != 0, () -> "An external 'receiver' [" + this.receiver + "] can't be modified.");
    }

    public S selectorExpression(Expression selectorExpression) {
        this.assertReceiver();
        ((AbstractMailReceiver)this.receiver).setSelectorExpression(selectorExpression);
        return (S)((Object)((MailInboundChannelAdapterSpec)this._this()));
    }

    public S selector(Function<MimeMessage, Boolean> selectorFunction) {
        this.assertReceiver();
        ((AbstractMailReceiver)this.receiver).setSelectorExpression((Expression)new FunctionExpression(selectorFunction));
        return (S)((Object)((MailInboundChannelAdapterSpec)this._this()));
    }

    public S session(Session session) {
        this.assertReceiver();
        ((AbstractMailReceiver)this.receiver).setSession(session);
        this.sessionProvided = true;
        return (S)((Object)((MailInboundChannelAdapterSpec)this._this()));
    }

    public S javaMailProperties(Properties javaMailProperties) {
        this.assertReceiver();
        this.assertSession();
        ((AbstractMailReceiver)this.receiver).setJavaMailProperties(javaMailProperties);
        return (S)((Object)((MailInboundChannelAdapterSpec)this._this()));
    }

    private void assertSession() {
        Assert.state((!this.sessionProvided ? 1 : 0) != 0, (String)"Neither 'javaMailProperties' nor 'javaMailAuthenticator' references are allowed when a 'session' reference has been provided.");
    }

    public S javaMailProperties(Consumer<PropertiesBuilder> configurer) {
        PropertiesBuilder properties = new PropertiesBuilder();
        configurer.accept(properties);
        return this.javaMailProperties(properties.get());
    }

    public S javaMailAuthenticator(Authenticator javaMailAuthenticator) {
        this.assertSession();
        this.assertReceiver();
        ((AbstractMailReceiver)this.receiver).setJavaMailAuthenticator(javaMailAuthenticator);
        return (S)((Object)((MailInboundChannelAdapterSpec)this._this()));
    }

    public S maxFetchSize(int maxFetchSize) {
        this.assertReceiver();
        ((AbstractMailReceiver)this.receiver).setMaxFetchSize(maxFetchSize);
        return (S)((Object)((MailInboundChannelAdapterSpec)this._this()));
    }

    public S shouldDeleteMessages(boolean shouldDeleteMessages) {
        this.assertReceiver();
        ((AbstractMailReceiver)this.receiver).setShouldDeleteMessages(shouldDeleteMessages);
        return (S)((Object)((MailInboundChannelAdapterSpec)this._this()));
    }

    public S userFlag(String userFlag) {
        this.assertReceiver();
        ((AbstractMailReceiver)this.receiver).setUserFlag(userFlag);
        return (S)((Object)((MailInboundChannelAdapterSpec)this._this()));
    }

    public S headerMapper(HeaderMapper<MimeMessage> headerMapper) {
        this.assertReceiver();
        ((AbstractMailReceiver)this.receiver).setHeaderMapper(headerMapper);
        return (S)((Object)((MailInboundChannelAdapterSpec)this._this()));
    }

    public S embeddedPartsAsBytes(boolean embeddedPartsAsBytes) {
        this.assertReceiver();
        ((AbstractMailReceiver)this.receiver).setEmbeddedPartsAsBytes(embeddedPartsAsBytes);
        return (S)((Object)((MailInboundChannelAdapterSpec)this._this()));
    }

    public S simpleContent(boolean simpleContent) {
        this.assertReceiver();
        ((AbstractMailReceiver)this.receiver).setSimpleContent(simpleContent);
        return (S)((Object)((MailInboundChannelAdapterSpec)this._this()));
    }

    public Map<Object, String> getComponentsToRegister() {
        return Collections.singletonMap(this.receiver, this.receiver.getComponentName());
    }

    public MailReceivingMessageSource doGet() {
        return new MailReceivingMessageSource((MailReceiver)this.receiver);
    }
}

