/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.AbstractChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.mail.ImapIdleChannelAdapter;
import org.springframework.integration.mail.ImapMailReceiver;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ImapIdleChannelAdapterParser
extends AbstractChannelAdapterParser {
    protected AbstractBeanDefinition doParse(Element element, ParserContext parserContext, String channelName) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ImapIdleChannelAdapter.class);
        builder.addConstructorArgValue((Object)this.parseImapMailReceiver(element, parserContext));
        builder.addPropertyReference("outputChannel", channelName);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-channel", (String)"errorChannel");
        Element txElement = DomUtils.getChildElementByTagName((Element)element, (String)"transactional");
        if (txElement != null) {
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)txElement, (String)"synchronization-factory", (String)"transactionSynchronizationFactory");
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"task-executor", (String)"sendingTaskExecutor");
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        IntegrationNamespaceUtils.configureAndSetAdviceChainIfPresent(null, (Element)DomUtils.getChildElementByTagName((Element)element, (String)"transactional"), (BeanDefinition)beanDefinition, (ParserContext)parserContext);
        return beanDefinition;
    }

    private BeanDefinition parseImapMailReceiver(Element element, ParserContext parserContext) {
        String selectorExpression;
        String session;
        BeanDefinitionBuilder receiverBuilder = BeanDefinitionBuilder.genericBeanDefinition(ImapMailReceiver.class);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"search-term-strategy");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"user-flag");
        Object source = parserContext.extractSource((Object)element);
        String uri = element.getAttribute("store-uri");
        if (StringUtils.hasText((String)uri)) {
            receiverBuilder.addConstructorArgValue((Object)uri);
        }
        if (StringUtils.hasText((String)(session = element.getAttribute("session")))) {
            if (element.hasAttribute("java-mail-properties") || element.hasAttribute("authenticator")) {
                parserContext.getReaderContext().error("Neither 'java-mail-properties' nor 'authenticator' references are allowed when a 'session' reference has been provided.", source);
            }
            receiverBuilder.addPropertyReference("session", session);
        } else {
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"java-mail-properties");
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"authenticator", (String)"javaMailAuthenticator");
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"max-fetch-size");
        receiverBuilder.addPropertyValue("shouldDeleteMessages", (Object)element.getAttribute("should-delete-messages"));
        String markAsRead = element.getAttribute("should-mark-messages-as-read");
        if (StringUtils.hasText((String)markAsRead)) {
            receiverBuilder.addPropertyValue("shouldMarkMessagesAsRead", (Object)markAsRead);
        }
        if (StringUtils.hasText((String)(selectorExpression = element.getAttribute("mail-filter-expression")))) {
            RootBeanDefinition expressionDef = new RootBeanDefinition(ExpressionFactoryBean.class);
            expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)selectorExpression);
            receiverBuilder.addPropertyValue("selectorExpression", (Object)expressionDef);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"header-mapper");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"embedded-parts-as-bytes");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"simple-content");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"auto-close-folder");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"cancel-idle-interval");
        return receiverBuilder.getBeanDefinition();
    }
}

