/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.inbound;

import com.mongodb.DBObject;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.transaction.IntegrationResourceHolder;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MongoDbMessageSource
extends AbstractMessageSource<Object> {
    @Nullable
    private final MongoDatabaseFactory mongoDbFactory;
    private final Expression queryExpression;
    private Expression collectionNameExpression = new LiteralExpression("data");
    private StandardEvaluationContext evaluationContext;
    private MongoOperations mongoTemplate;
    private MongoConverter mongoConverter;
    private Class<?> entityClass = DBObject.class;
    private boolean expectSingleResult = false;
    private volatile boolean initialized = false;

    public MongoDbMessageSource(MongoDatabaseFactory mongoDbFactory, Expression queryExpression) {
        Assert.notNull((Object)mongoDbFactory, (String)"'mongoDbFactory' must not be null");
        Assert.notNull((Object)queryExpression, (String)"'queryExpression' must not be null");
        this.mongoDbFactory = mongoDbFactory;
        this.queryExpression = queryExpression;
    }

    public MongoDbMessageSource(MongoOperations mongoTemplate, Expression queryExpression) {
        Assert.notNull((Object)mongoTemplate, (String)"'mongoTemplate' must not be null");
        Assert.notNull((Object)queryExpression, (String)"'queryExpression' must not be null");
        this.mongoDbFactory = null;
        this.mongoTemplate = mongoTemplate;
        this.queryExpression = queryExpression;
    }

    public void setEntityClass(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"'entityClass' must not be null");
        this.entityClass = entityClass;
    }

    public void setExpectSingleResult(boolean expectSingleResult) {
        this.expectSingleResult = expectSingleResult;
    }

    public void setCollectionNameExpression(Expression collectionNameExpression) {
        Assert.notNull((Object)collectionNameExpression, (String)"'collectionNameExpression' must not be null");
        this.collectionNameExpression = collectionNameExpression;
    }

    public void setMongoConverter(MongoConverter mongoConverter) {
        Assert.isNull((Object)this.mongoTemplate, (String)"'mongoConverter' can not be set when instance was constructed with MongoTemplate");
        this.mongoConverter = mongoConverter;
    }

    public String getComponentType() {
        return "mongo:inbound-channel-adapter";
    }

    protected void onInit() {
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        TypeLocator typeLocator = this.evaluationContext.getTypeLocator();
        if (typeLocator instanceof StandardTypeLocator) {
            ((StandardTypeLocator)typeLocator).registerImport("org.springframework.data.mongodb.core.query");
        }
        if (this.mongoDbFactory != null) {
            this.mongoTemplate = new MongoTemplate(this.mongoDbFactory, this.mongoConverter);
        }
        this.initialized = true;
    }

    protected Object doReceive() {
        Object holder;
        BasicQuery query;
        Assert.isTrue((boolean)this.initialized, (String)"This class is not yet initialized. Invoke its afterPropertiesSet() method");
        AbstractIntegrationMessageBuilder messageBuilder = null;
        Object value = this.queryExpression.getValue((EvaluationContext)this.evaluationContext);
        Assert.notNull((Object)value, (String)"'queryExpression' must not evaluate to null");
        if (value instanceof String) {
            query = new BasicQuery((String)value);
        } else if (value instanceof Query) {
            query = (Query)value;
        } else {
            throw new IllegalStateException("'queryExpression' must evaluate to String or org.springframework.data.mongodb.core.query.Query");
        }
        Assert.notNull((Object)query, (String)"'queryExpression' must not evaluate to null");
        String collectionName = (String)this.collectionNameExpression.getValue((EvaluationContext)this.evaluationContext, String.class);
        Assert.notNull((Object)collectionName, (String)"'collectionNameExpression' must not evaluate to null");
        Object result = null;
        if (this.expectSingleResult) {
            result = this.mongoTemplate.findOne((Query)query, this.entityClass, collectionName);
        } else {
            List results = this.mongoTemplate.find((Query)query, this.entityClass, collectionName);
            if (!CollectionUtils.isEmpty((Collection)results)) {
                result = results;
            }
        }
        if (result != null) {
            messageBuilder = this.getMessageBuilderFactory().withPayload(result).setHeader("mongo_collectionName", (Object)collectionName);
        }
        if ((holder = TransactionSynchronizationManager.getResource((Object)((Object)this))) != null) {
            Assert.isInstanceOf(IntegrationResourceHolder.class, (Object)holder);
            ((IntegrationResourceHolder)holder).addAttribute("mongoTemplate", (Object)this.mongoTemplate);
        }
        return messageBuilder;
    }
}

