/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.outbound;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class MongoDbStoringMessageHandler
extends AbstractMessageHandler {
    private volatile MongoOperations mongoTemplate;
    private volatile MongoDatabaseFactory mongoDbFactory;
    private volatile MongoConverter mongoConverter;
    private volatile StandardEvaluationContext evaluationContext;
    private volatile Expression collectionNameExpression = new LiteralExpression("data");
    private volatile boolean initialized = false;

    public MongoDbStoringMessageHandler(MongoDatabaseFactory mongoDbFactory) {
        Assert.notNull((Object)mongoDbFactory, (String)"'mongoDbFactory' must not be null");
        this.mongoDbFactory = mongoDbFactory;
    }

    public MongoDbStoringMessageHandler(MongoOperations mongoTemplate) {
        Assert.notNull((Object)mongoTemplate, (String)"'mongoTemplate' must not be null");
        this.mongoTemplate = mongoTemplate;
    }

    public void setMongoConverter(MongoConverter mongoConverter) {
        Assert.isNull((Object)this.mongoTemplate, (String)"'mongoConverter' can not be set when instance was constructed with MongoTemplate");
        this.mongoConverter = mongoConverter;
    }

    public void setCollectionNameExpression(Expression collectionNameExpression) {
        Assert.notNull((Object)collectionNameExpression, (String)"'collectionNameExpression' must not be null");
        this.collectionNameExpression = collectionNameExpression;
    }

    public String getComponentType() {
        return "mongo:outbound-channel-adapter";
    }

    protected void onInit() {
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        if (this.mongoTemplate == null) {
            this.mongoTemplate = new MongoTemplate(this.mongoDbFactory, this.mongoConverter);
        }
        this.initialized = true;
    }

    protected void handleMessageInternal(Message<?> message) {
        Assert.isTrue((boolean)this.initialized, (String)"This class is not yet initialized. Invoke its afterPropertiesSet() method");
        String collectionName = (String)this.collectionNameExpression.getValue((EvaluationContext)this.evaluationContext, message, String.class);
        Assert.notNull((Object)collectionName, (String)"'collectionNameExpression' must not evaluate to null");
        Object payload = message.getPayload();
        this.mongoTemplate.save(payload, collectionName);
    }
}

