/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.dsl;

import java.util.function.Function;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.ReactiveMessageHandlerSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.mongodb.outbound.ReactiveMongoDbStoringMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.ReactiveMessageHandler;

public class ReactiveMongoDbMessageHandlerSpec
extends ReactiveMessageHandlerSpec<ReactiveMongoDbMessageHandlerSpec, ReactiveMongoDbStoringMessageHandler>
implements ComponentsRegistration {
    protected ReactiveMongoDbMessageHandlerSpec(ReactiveMongoDatabaseFactory mongoDbFactory) {
        super((ReactiveMessageHandler)new ReactiveMongoDbStoringMessageHandler(mongoDbFactory));
    }

    protected ReactiveMongoDbMessageHandlerSpec(ReactiveMongoOperations reactiveMongoOperations) {
        super((ReactiveMessageHandler)new ReactiveMongoDbStoringMessageHandler(reactiveMongoOperations));
    }

    public ReactiveMongoDbMessageHandlerSpec mongoConverter(MongoConverter mongoConverter) {
        ((ReactiveMongoDbStoringMessageHandler)this.reactiveMessageHandler).setMongoConverter(mongoConverter);
        return this;
    }

    public ReactiveMongoDbMessageHandlerSpec collectionName(String collectionName) {
        return this.collectionNameExpression((Expression)new LiteralExpression(collectionName));
    }

    public <P> ReactiveMongoDbMessageHandlerSpec collectionNameFunction(Function<Message<P>, String> collectionNameFunction) {
        return this.collectionNameExpression((Expression)new FunctionExpression(collectionNameFunction));
    }

    public ReactiveMongoDbMessageHandlerSpec collectionNameExpression(Expression collectionNameExpression) {
        ((ReactiveMongoDbStoringMessageHandler)this.reactiveMessageHandler).setCollectionNameExpression(collectionNameExpression);
        return this;
    }
}

