/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.dsl;

import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.mongodb.dsl.MongoDbChangeStreamMessageProducerSpec;
import org.springframework.integration.mongodb.dsl.MongoDbMessageSourceSpec;
import org.springframework.integration.mongodb.dsl.MongoDbOutboundGatewaySpec;
import org.springframework.integration.mongodb.dsl.ReactiveMongoDbMessageHandlerSpec;
import org.springframework.integration.mongodb.dsl.ReactiveMongoDbMessageSourceSpec;
import org.springframework.integration.mongodb.inbound.MongoDbChangeStreamMessageProducer;

public final class MongoDb {
    public static MongoDbOutboundGatewaySpec outboundGateway(MongoDatabaseFactory mongoDbFactory, MongoConverter mongoConverter) {
        return new MongoDbOutboundGatewaySpec(mongoDbFactory, mongoConverter);
    }

    public static MongoDbOutboundGatewaySpec outboundGateway(MongoOperations mongoTemplate) {
        return new MongoDbOutboundGatewaySpec(mongoTemplate);
    }

    public static ReactiveMongoDbMessageHandlerSpec reactiveOutboundChannelAdapter(ReactiveMongoDatabaseFactory mongoDbFactory) {
        return new ReactiveMongoDbMessageHandlerSpec(mongoDbFactory);
    }

    public static ReactiveMongoDbMessageHandlerSpec reactiveOutboundChannelAdapter(ReactiveMongoOperations mongoTemplate) {
        return new ReactiveMongoDbMessageHandlerSpec(mongoTemplate);
    }

    public static ReactiveMongoDbMessageSourceSpec reactiveInboundChannelAdapter(ReactiveMongoDatabaseFactory mongoDbFactory, String query) {
        return new ReactiveMongoDbMessageSourceSpec(mongoDbFactory, (Expression)new LiteralExpression(query));
    }

    public static ReactiveMongoDbMessageSourceSpec reactiveInboundChannelAdapter(ReactiveMongoDatabaseFactory mongoDbFactory, Query query) {
        return new ReactiveMongoDbMessageSourceSpec(mongoDbFactory, (Expression)new ValueExpression((Object)query));
    }

    public static ReactiveMongoDbMessageSourceSpec reactiveInboundChannelAdapter(ReactiveMongoOperations mongoTemplate, String query) {
        return new ReactiveMongoDbMessageSourceSpec(mongoTemplate, (Expression)new LiteralExpression(query));
    }

    public static ReactiveMongoDbMessageSourceSpec reactiveInboundChannelAdapter(ReactiveMongoOperations mongoTemplate, Query query) {
        return new ReactiveMongoDbMessageSourceSpec(mongoTemplate, (Expression)new ValueExpression((Object)query));
    }

    public static MongoDbChangeStreamMessageProducerSpec changeStreamInboundChannelAdapter(ReactiveMongoOperations mongoOperations) {
        return new MongoDbChangeStreamMessageProducerSpec(new MongoDbChangeStreamMessageProducer(mongoOperations));
    }

    public static MongoDbMessageSourceSpec inboundChannelAdapter(MongoDatabaseFactory mongoDbFactory, String query) {
        return new MongoDbMessageSourceSpec(mongoDbFactory, (Expression)new LiteralExpression(query));
    }

    public static MongoDbMessageSourceSpec inboundChannelAdapter(MongoDatabaseFactory mongoDbFactory, Query query) {
        return new MongoDbMessageSourceSpec(mongoDbFactory, (Expression)new ValueExpression((Object)query));
    }

    public static MongoDbMessageSourceSpec inboundChannelAdapter(MongoOperations mongoTemplate, String query) {
        return new MongoDbMessageSourceSpec(mongoTemplate, (Expression)new LiteralExpression(query));
    }

    public static MongoDbMessageSourceSpec reactiveInboundChannelAdapter(MongoOperations mongoTemplate, Query query) {
        return new MongoDbMessageSourceSpec(mongoTemplate, (Expression)new ValueExpression((Object)query));
    }

    private MongoDb() {
    }
}

