/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.outbound;

import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.integration.mqtt.core.DefaultMqttPahoClientFactory;
import org.springframework.integration.mqtt.core.MqttPahoClientFactory;
import org.springframework.integration.mqtt.event.MqttMessageDeliveredEvent;
import org.springframework.integration.mqtt.event.MqttMessageSentEvent;
import org.springframework.integration.mqtt.outbound.AbstractMqttMessageHandler;
import org.springframework.integration.mqtt.support.MqttMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class MqttPahoMessageHandler
extends AbstractMqttMessageHandler
implements MqttCallback,
ApplicationEventPublisherAware {
    public static final long DEFAULT_COMPLETION_TIMEOUT = 30000L;
    private long completionTimeout = 30000L;
    private final MqttPahoClientFactory clientFactory;
    private boolean async;
    private boolean asyncEvents;
    private ApplicationEventPublisher applicationEventPublisher;
    private volatile IMqttAsyncClient client;

    public MqttPahoMessageHandler(String url, String clientId, MqttPahoClientFactory clientFactory) {
        super(url, clientId);
        this.clientFactory = clientFactory;
    }

    public MqttPahoMessageHandler(String clientId, MqttPahoClientFactory clientFactory) {
        super(null, clientId);
        this.clientFactory = clientFactory;
    }

    public MqttPahoMessageHandler(String url, String clientId) {
        this(url, clientId, new DefaultMqttPahoClientFactory());
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setAsyncEvents(boolean asyncEvents) {
        this.asyncEvents = asyncEvents;
    }

    public void setCompletionTimeout(long completionTimeout) {
        this.completionTimeout = completionTimeout;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    protected void onInit() {
        super.onInit();
        Assert.state((boolean)(this.getConverter() instanceof MqttMessageConverter), (String)"MessageConverter must be an MqttMessageConverter");
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
        try {
            IMqttAsyncClient theClient = this.client;
            if (theClient != null) {
                theClient.disconnect().waitForCompletion(this.completionTimeout);
                theClient.close();
                this.client = null;
            }
        }
        catch (MqttException e) {
            this.logger.error((Object)"Failed to disconnect", (Throwable)e);
        }
    }

    private synchronized IMqttAsyncClient checkConnection() throws MqttException {
        if (this.client != null && !this.client.isConnected()) {
            this.client.setCallback(null);
            this.client.close();
            this.client = null;
        }
        if (this.client == null) {
            try {
                MqttConnectOptions connectionOptions = this.clientFactory.getConnectionOptions();
                Assert.state((this.getUrl() != null || connectionOptions.getServerURIs() != null ? 1 : 0) != 0, (String)"If no 'url' provided, connectionOptions.getServerURIs() must not be null");
                this.client = this.clientFactory.getAsyncClientInstance(this.getUrl(), this.getClientId());
                this.incrementClientInstance();
                this.client.setCallback((MqttCallback)this);
                this.client.connect(connectionOptions).waitForCompletion(this.completionTimeout);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Client connected");
                }
            }
            catch (MqttException e) {
                if (this.client != null) {
                    this.client.close();
                    this.client = null;
                }
                throw new MessagingException("Failed to connect", (Throwable)e);
            }
        }
        return this.client;
    }

    @Override
    protected void publish(String topic, Object mqttMessage, Message<?> message) throws Exception {
        Assert.isInstanceOf(MqttMessage.class, (Object)mqttMessage);
        IMqttDeliveryToken token = this.checkConnection().publish(topic, (MqttMessage)mqttMessage);
        if (!this.async) {
            token.waitForCompletion(this.completionTimeout);
        } else if (this.asyncEvents && this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new MqttMessageSentEvent((Object)this, message, topic, token.getMessageId(), this.getClientId(), this.getClientInstance()));
        }
    }

    private void sendDeliveryComplete(IMqttDeliveryToken token) {
        if (this.async && this.asyncEvents && this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new MqttMessageDeliveredEvent((Object)this, token.getMessageId(), this.getClientId(), this.getClientInstance()));
        }
    }

    public synchronized void connectionLost(Throwable cause) {
        this.logger.error((Object)"Lost connection; will attempt reconnect on next request");
        if (this.client != null) {
            try {
                this.client.setCallback(null);
                this.client.close();
            }
            catch (MqttException mqttException) {
                // empty catch block
            }
            this.client = null;
        }
    }

    public void messageArrived(String topic, MqttMessage message) {
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        this.sendDeliveryComplete(token);
    }
}

