/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.outbound;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.redis.outbound.ArgumentsStrategy;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class RedisOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private final RedisTemplate<?, ?> redisTemplate;
    private EvaluationContext evaluationContext;
    private volatile RedisSerializer<Object> argumentsSerializer = new GenericToStringSerializer(Object.class);
    private volatile Expression commandExpression = PARSER.parseExpression("headers[redis_command]");
    private volatile ArgumentsStrategy argumentsStrategy = new PayloadArgumentsStrategy();

    public RedisOutboundGateway(RedisTemplate<?, ?> redisTemplate) {
        Assert.notNull(redisTemplate, (String)"'redisTemplate' must not be null");
        this.redisTemplate = redisTemplate;
    }

    public RedisOutboundGateway(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' must not be null");
        this.redisTemplate = new RedisTemplate();
        this.redisTemplate.setConnectionFactory(connectionFactory);
        this.redisTemplate.afterPropertiesSet();
    }

    public void setArgumentsSerializer(RedisSerializer<?> serializer) {
        Assert.notNull(serializer, (String)"'serializer' must not be null");
        this.argumentsSerializer = serializer;
    }

    public void setCommandExpression(Expression commandExpression) {
        this.commandExpression = commandExpression;
    }

    public void setCommandExpressionString(String commandExpression) {
        Assert.hasText((String)commandExpression, (String)"'commandExpression' must not be empty");
        this.commandExpression = EXPRESSION_PARSER.parseExpression(commandExpression);
    }

    @Deprecated
    public void setExpressionCommand(Expression commandExpression) {
        this.setCommandExpression(commandExpression);
    }

    public void setArgumentsStrategy(ArgumentsStrategy argumentsStrategy) {
        this.argumentsStrategy = argumentsStrategy;
    }

    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public String getComponentType() {
        return "redis:outbound-gateway";
    }

    protected void doInit() {
        super.doInit();
        if (this.evaluationContext == null) {
            this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        Object[] arguments;
        final String command = (String)this.commandExpression.getValue(this.evaluationContext, requestMessage, String.class);
        Assert.notNull((Object)command, (String)"The 'command' must not evaluate to 'null'.");
        Object args = null;
        if (this.argumentsStrategy != null && !ObjectUtils.isEmpty((Object[])(arguments = this.argumentsStrategy.resolve(command, requestMessage)))) {
            args = new byte[arguments.length][];
            for (int i = 0; i < arguments.length; ++i) {
                Object argument = arguments[i];
                byte[] arg = null;
                arg = argument instanceof byte[] ? (byte[])argument : this.argumentsSerializer.serialize(argument);
                args[i] = arg;
            }
        }
        final byte[][] actualArgs = args;
        return this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.execute(command, actualArgs);
            }
        });
    }

    private class PayloadArgumentsStrategy
    implements ArgumentsStrategy {
        private PayloadArgumentsStrategy() {
        }

        @Override
        public Object[] resolve(String command, Message<?> message) {
            Object payload = message.getPayload();
            if (payload instanceof Object[]) {
                return (Object[])payload;
            }
            return new Object[]{payload};
        }
    }
}

