/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.redis.inbound.RedisStoreMessageSource;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RedisStoreInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(RedisStoreMessageSource.class);
        String redisTemplate = element.getAttribute("redis-template");
        String connectionFactory = element.getAttribute("connection-factory");
        if (StringUtils.hasText((String)redisTemplate) && StringUtils.hasText((String)connectionFactory)) {
            parserContext.getReaderContext().error("Only one of '" + redisTemplate + "' or '" + connectionFactory + "' is allowed.", (Object)element);
        }
        if (StringUtils.hasText((String)redisTemplate)) {
            builder.addConstructorArgReference(redisTemplate);
        } else {
            if (!StringUtils.hasText((String)connectionFactory)) {
                connectionFactory = "redisConnectionFactory";
            }
            builder.addConstructorArgReference(connectionFactory);
        }
        boolean atLeastOneRequired = true;
        BeanDefinition expressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"key", (String)"key-expression", (ParserContext)parserContext, (Element)element, (boolean)atLeastOneRequired);
        builder.addConstructorArgValue((Object)expressionDef);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"collection-type");
        return builder.getBeanDefinition();
    }
}

