/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.rsocket;

import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import io.rsocket.transport.netty.client.WebsocketClientTransport;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.integration.rsocket.AbstractRSocketConnector;
import org.springframework.integration.rsocket.IntegrationRSocketMessageHandler;
import org.springframework.messaging.rsocket.RSocketConnectorConfigurer;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;

public class ClientRSocketConnector
extends AbstractRSocketConnector {
    private final ClientTransport clientTransport;
    private final Map<Object, MimeType> setupMetadata = new LinkedHashMap<Object, MimeType>(4);
    private RSocketConnectorConfigurer connectorConfigurer = connector -> {};
    private Object setupData;
    private String setupRoute;
    private Object[] setupRouteVars = new Object[0];
    private boolean autoConnect;
    private RSocketRequester rsocketRequester;

    public ClientRSocketConnector(String host, int port) {
        this((ClientTransport)TcpClientTransport.create((String)host, (int)port));
    }

    public ClientRSocketConnector(URI uri) {
        this((ClientTransport)WebsocketClientTransport.create((URI)uri));
    }

    public ClientRSocketConnector(ClientTransport clientTransport) {
        super(new IntegrationRSocketMessageHandler());
        Assert.notNull((Object)clientTransport, (String)"'clientTransport' must not be null");
        this.clientTransport = clientTransport;
    }

    public void setConnectorConfigurer(RSocketConnectorConfigurer connectorConfigurer) {
        Assert.notNull((Object)connectorConfigurer, (String)"'connectorConfigurer' must not be null");
        this.connectorConfigurer = connectorConfigurer;
    }

    public void setSetupRoute(String setupRoute) {
        Assert.notNull((Object)setupRoute, (String)"'setupRoute' must not be null");
        this.setupRoute = setupRoute;
    }

    public void setSetupRouteVariables(Object ... setupRouteVars) {
        Assert.notNull((Object)setupRouteVars, (String)"'setupRouteVars' must not be null");
        this.setupRouteVars = Arrays.copyOf(setupRouteVars, setupRouteVars.length);
    }

    public void setSetupMetadata(Map<Object, MimeType> setupMetadata) {
        Assert.notNull(setupMetadata, (String)"'setupMetadata' must not be null");
        this.setupMetadata.clear();
        this.setupMetadata.putAll(setupMetadata);
    }

    public void setSetupData(Object setupData) {
        Assert.notNull((Object)setupData, (String)"'setupData' must not be null");
        this.setupData = setupData;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.rsocketRequester = RSocketRequester.builder().dataMimeType(this.getDataMimeType()).metadataMimeType(this.getMetadataMimeType()).rsocketStrategies(this.getRSocketStrategies()).setupData(this.setupData).setupRoute(this.setupRoute, this.setupRouteVars).rsocketConnector(this.connectorConfigurer).rsocketConnector(connector -> connector.acceptor(this.rSocketMessageHandler.responder())).apply(builder -> this.setupMetadata.forEach((arg_0, arg_1) -> ((RSocketRequester.Builder)builder).setupMetadata(arg_0, arg_1))).transport(this.clientTransport);
    }

    @Override
    public void afterSingletonsInstantiated() {
        this.autoConnect = this.rSocketMessageHandler.detectEndpoints();
    }

    @Override
    protected void doStart() {
        if (this.autoConnect) {
            this.connect();
        }
    }

    public void destroy() {
        this.rsocketRequester.rsocketClient().dispose();
    }

    public void connect() {
        this.rsocketRequester.rsocketClient().source().subscribe();
    }

    public RSocketRequester getRequester() {
        return this.rsocketRequester;
    }
}

