/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting.dsl;

import java.util.Collections;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageSourceSpec;
import org.springframework.integration.endpoint.MessageProcessorMessageSource;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.scripting.ScriptVariableGenerator;
import org.springframework.integration.scripting.dsl.ScriptSpec;
import org.springframework.integration.support.MapBuilder;

public class ScriptMessageSourceSpec
extends MessageSourceSpec<ScriptMessageSourceSpec, MessageSource<?>>
implements ComponentsRegistration {
    private final ScriptSpec delegate;

    public ScriptMessageSourceSpec(Resource scriptResource) {
        this.delegate = new ScriptSpec(scriptResource);
    }

    public ScriptMessageSourceSpec(String scriptLocation) {
        this.delegate = new ScriptSpec(scriptLocation);
    }

    public ScriptMessageSourceSpec lang(String lang) {
        this.delegate.lang(lang);
        return this;
    }

    public ScriptMessageSourceSpec variableGenerator(ScriptVariableGenerator variableGenerator) {
        this.delegate.variableGenerator(variableGenerator);
        return this;
    }

    public ScriptMessageSourceSpec variables(MapBuilder<?, String, Object> variables) {
        this.delegate.variables(variables);
        return this;
    }

    public ScriptMessageSourceSpec variables(Map<String, Object> variables) {
        this.delegate.variables(variables);
        return this;
    }

    public ScriptMessageSourceSpec variable(String name, Object value) {
        this.delegate.variable(name, value);
        return this;
    }

    public ScriptMessageSourceSpec refreshCheckDelay(long refreshCheckDelay) {
        this.delegate.refreshCheckDelay(refreshCheckDelay);
        return this;
    }

    protected MessageSource<?> doGet() {
        return new MessageProcessorMessageSource((MessageProcessor)this.delegate.get());
    }

    public Map<Object, String> getComponentsToRegister() {
        return Collections.singletonMap(this.delegate.get(), this.delegate.getId());
    }
}

