/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting.dsl;

import java.util.HashMap;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.integration.dsl.MessageProcessorSpec;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.scripting.DefaultScriptVariableGenerator;
import org.springframework.integration.scripting.ScriptVariableGenerator;
import org.springframework.integration.scripting.dsl.DslScriptExecutingMessageProcessor;
import org.springframework.integration.support.MapBuilder;
import org.springframework.util.Assert;

public class ScriptSpec
extends MessageProcessorSpec<ScriptSpec> {
    private final DslScriptExecutingMessageProcessor processor;
    private ScriptVariableGenerator variableGenerator;
    private final Map<String, Object> variables = new HashMap<String, Object>();

    ScriptSpec(Resource scriptResource) {
        Assert.notNull((Object)scriptResource, (String)"'scriptResource' must not be null");
        this.processor = new DslScriptExecutingMessageProcessor(scriptResource);
    }

    ScriptSpec(String scriptLocation) {
        Assert.hasText((String)scriptLocation, (String)"'scriptLocation' must not be empty");
        this.processor = new DslScriptExecutingMessageProcessor(scriptLocation);
    }

    public ScriptSpec lang(String lang) {
        Assert.hasText((String)lang, (String)"'lang' must not be empty");
        this.processor.setLang(lang);
        return this;
    }

    public ScriptSpec refreshCheckDelay(long refreshCheckDelay) {
        this.processor.setRefreshCheckDelay(refreshCheckDelay);
        return this;
    }

    public ScriptSpec variableGenerator(ScriptVariableGenerator variableGenerator) {
        Assert.notNull((Object)variableGenerator, (String)"'variableGenerator' must not be null");
        Assert.state((boolean)this.variables.isEmpty(), (String)"'variableGenerator' and 'variables' are mutually exclusive");
        this.variableGenerator = variableGenerator;
        return this;
    }

    public ScriptSpec variables(MapBuilder<?, String, Object> variables) {
        return this.variables(variables.get());
    }

    public ScriptSpec variables(Map<String, Object> variables) {
        Assert.notEmpty(variables, (String)"'variables' must not be empty");
        Assert.state((this.variableGenerator == null ? 1 : 0) != 0, (String)"'variableGenerator' and 'variables' are mutually exclusive");
        this.variables.putAll(variables);
        return this;
    }

    public ScriptSpec variable(String name, Object value) {
        Assert.hasText((String)name, (String)"'name' must not be empty");
        Assert.state((this.variableGenerator == null ? 1 : 0) != 0, (String)"'variableGenerator' and 'variables' are mutually exclusive");
        this.variables.put(name, value);
        return this;
    }

    protected MessageProcessor<?> doGet() {
        if (this.variableGenerator == null) {
            this.variableGenerator = new DefaultScriptVariableGenerator(this.variables);
        }
        this.processor.setVariableGenerator(this.variableGenerator);
        return this.processor;
    }
}

