/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.security.config;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.core.type.MethodMetadata;
import org.springframework.integration.config.IntegrationConfigurationInitializer;
import org.springframework.integration.security.channel.ChannelSecurityInterceptor;
import org.springframework.integration.security.channel.DefaultChannelAccessPolicy;
import org.springframework.integration.security.channel.SecuredChannel;
import org.springframework.integration.security.config.ChannelSecurityInterceptorBeanPostProcessor;

public class SecurityIntegrationConfigurationInitializer
implements IntegrationConfigurationInitializer {
    private static final String CHANNEL_SECURITY_INTERCEPTOR_BPP_BEAN_NAME = ChannelSecurityInterceptorBeanPostProcessor.class.getName();

    public void initialize(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        ManagedMap securityInterceptors = new ManagedMap();
        HashMap policies = new HashMap();
        for (String beanName : registry.getBeanDefinitionNames()) {
            String annotationType;
            MethodMetadata beanMethod;
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            if (ChannelSecurityInterceptor.class.getName().equals(beanDefinition.getBeanClassName())) {
                BeanDefinition metadataSource = (BeanDefinition)beanDefinition.getConstructorArgumentValues().getIndexedArgumentValue(0, BeanDefinition.class).getValue();
                Map value = (Map)metadataSource.getConstructorArgumentValues().getIndexedArgumentValue(0, Map.class).getValue();
                ManagedSet patterns = new ManagedSet();
                if (!securityInterceptors.containsKey(beanName)) {
                    securityInterceptors.put(beanName, patterns);
                } else {
                    patterns = (ManagedSet)securityInterceptors.get(beanName);
                }
                patterns.addAll(value.keySet());
                continue;
            }
            if (!(beanDefinition instanceof AnnotatedBeanDefinition) || !(beanDefinition.getSource() instanceof MethodMetadata) || !(beanMethod = (MethodMetadata)beanDefinition.getSource()).isAnnotated(annotationType = SecuredChannel.class.getName())) continue;
            Map securedAttributes = beanMethod.getAnnotationAttributes(annotationType);
            String[] interceptors = (String[])securedAttributes.get("interceptor");
            String[] sendAccess = (String[])securedAttributes.get("sendAccess");
            String[] receiveAccess = (String[])securedAttributes.get("receiveAccess");
            DefaultChannelAccessPolicy accessPolicy = new DefaultChannelAccessPolicy(sendAccess, receiveAccess);
            for (String interceptor : interceptors) {
                ManagedSet patterns = new ManagedSet();
                if (!securityInterceptors.containsKey(interceptor)) {
                    securityInterceptors.put(interceptor, patterns);
                } else {
                    patterns = (ManagedSet)securityInterceptors.get(interceptor);
                }
                patterns.add((Object)beanName);
                Map<Pattern, DefaultChannelAccessPolicy> mapping = new HashMap();
                if (!policies.containsKey(interceptor)) {
                    policies.put(interceptor, mapping);
                } else {
                    mapping = (Map)policies.get(interceptor);
                }
                mapping.put(Pattern.compile(beanName), accessPolicy);
            }
        }
        if (!securityInterceptors.isEmpty()) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ChannelSecurityInterceptorBeanPostProcessor.class).addConstructorArgValue((Object)securityInterceptors);
            if (!policies.isEmpty()) {
                builder.addConstructorArgValue(policies);
            }
            registry.registerBeanDefinition(CHANNEL_SECURITY_INTERCEPTOR_BPP_BEAN_NAME, (BeanDefinition)builder.getBeanDefinition());
        }
    }
}

