/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.security.config;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.security.channel.ChannelSecurityInterceptor;
import org.springframework.integration.security.channel.ChannelSecurityMetadataSource;
import org.springframework.integration.security.channel.DefaultChannelAccessPolicy;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SecuredChannelsParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return ChannelSecurityInterceptor.class;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.addConstructorArgValue((Object)this.parseSecurityMetadataSource(element, parserContext));
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"authentication-manager");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"access-decision-manager");
    }

    private BeanDefinition parseSecurityMetadataSource(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ChannelSecurityMetadataSource.class);
        List accessPolicyElements = DomUtils.getChildElementsByTagName((Element)element, (String)"access-policy");
        ManagedMap patternMappings = new ManagedMap();
        for (Element accessPolicyElement : accessPolicyElements) {
            String sendAccess = accessPolicyElement.getAttribute("send-access");
            String receiveAccess = accessPolicyElement.getAttribute("receive-access");
            if (!StringUtils.hasText((String)sendAccess) && !StringUtils.hasText((String)receiveAccess)) {
                parserContext.getReaderContext().error("At least one of 'send-access' or 'receive-access' must be provided.", (Object)accessPolicyElement);
            }
            BeanDefinitionBuilder accessPolicyBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultChannelAccessPolicy.class);
            accessPolicyBuilder.addConstructorArgValue((Object)sendAccess);
            accessPolicyBuilder.addConstructorArgValue((Object)receiveAccess);
            accessPolicyBuilder.getBeanDefinition().setRole(1);
            patternMappings.put((Object)accessPolicyElement.getAttribute("pattern"), (Object)accessPolicyBuilder.getBeanDefinition());
        }
        builder.addConstructorArgValue((Object)patternMappings);
        return builder.getBeanDefinition();
    }
}

