/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.inbound;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.sshd.sftp.client.SftpClient;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.AbstractRemoteFileStreamingMessageSource;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.integration.sftp.filters.SftpPersistentAcceptOnceFileListFilter;
import org.springframework.integration.sftp.session.SftpFileInfo;

public class SftpStreamingMessageSource
extends AbstractRemoteFileStreamingMessageSource<SftpClient.DirEntry> {
    public SftpStreamingMessageSource(RemoteFileTemplate<SftpClient.DirEntry> template) {
        this(template, null);
    }

    public SftpStreamingMessageSource(RemoteFileTemplate<SftpClient.DirEntry> template, Comparator<SftpClient.DirEntry> comparator) {
        super(template, comparator);
        this.doSetFilter((FileListFilter)new SftpPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "sftpStreamingMessageSource"));
    }

    public String getComponentType() {
        return "sftp:inbound-streaming-channel-adapter";
    }

    protected List<AbstractFileInfo<SftpClient.DirEntry>> asFileInfoList(Collection<SftpClient.DirEntry> files) {
        ArrayList<AbstractFileInfo<SftpClient.DirEntry>> canonicalFiles = new ArrayList<AbstractFileInfo<SftpClient.DirEntry>>();
        for (SftpClient.DirEntry file : files) {
            canonicalFiles.add(new SftpFileInfo(file));
        }
        return canonicalFiles;
    }

    protected boolean isDirectory(SftpClient.DirEntry file) {
        return file != null && file.getAttributes().isDirectory();
    }
}

