/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stomp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.stomp.StompSessionManager;
import org.springframework.integration.stomp.event.StompConnectionFailedEvent;
import org.springframework.integration.stomp.event.StompSessionConnectedEvent;
import org.springframework.messaging.simp.stomp.StompClientSupport;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.messaging.simp.stomp.StompSessionHandlerAdapter;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public abstract class AbstractStompSessionManager
implements StompSessionManager,
ApplicationEventPublisherAware,
SmartLifecycle,
DisposableBean,
BeanNameAware {
    private static final long DEFAULT_RECOVERY_INTERVAL = 10000L;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final CompositeStompSessionHandler compositeStompSessionHandler = new CompositeStompSessionHandler();
    private final Object lifecycleMonitor = new Object();
    protected final StompClientSupport stompClient;
    private final AtomicInteger epoch = new AtomicInteger();
    private boolean autoStartup = false;
    private boolean running = false;
    private int phase = 0x3FFFFFFF;
    private ApplicationEventPublisher applicationEventPublisher;
    private volatile StompHeaders connectHeaders;
    private volatile ListenableFuture<StompSession> stompSessionListenableFuture;
    private volatile boolean autoReceipt;
    private volatile boolean connecting;
    private volatile boolean connected;
    private volatile long recoveryInterval = 10000L;
    private volatile ScheduledFuture<?> reconnectFuture;
    private String name;

    public AbstractStompSessionManager(StompClientSupport stompClient) {
        Assert.notNull((Object)stompClient, (String)"'stompClient' is required.");
        this.stompClient = stompClient;
    }

    public void setConnectHeaders(StompHeaders connectHeaders) {
        this.connectHeaders = connectHeaders;
    }

    public void setAutoReceipt(boolean autoReceipt) {
        this.autoReceipt = autoReceipt;
    }

    @Override
    public boolean isAutoReceiptEnabled() {
        return this.autoReceipt;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public void setRecoveryInterval(int recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }

    private synchronized void connect() {
        if (this.connecting || this.connected) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Aborting connect; another thread is connecting.");
            }
            return;
        }
        final int epoch = this.epoch.get();
        this.connecting = true;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Connecting " + this));
        }
        try {
            this.stompSessionListenableFuture = this.doConnect((StompSessionHandler)this.compositeStompSessionHandler);
        }
        catch (Exception e) {
            if (epoch == this.epoch.get()) {
                this.scheduleReconnect(e);
            } else {
                this.logger.error((Object)("STOMP doConnect() error for " + this), (Throwable)e);
            }
            return;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.stompSessionListenableFuture.addCallback((ListenableFutureCallback)new ListenableFutureCallback<StompSession>(){

            public void onFailure(Throwable e) {
                if (AbstractStompSessionManager.this.logger.isDebugEnabled()) {
                    AbstractStompSessionManager.this.logger.debug((Object)"onFailure", e);
                }
                latch.countDown();
                if (epoch == AbstractStompSessionManager.this.epoch.get()) {
                    AbstractStompSessionManager.this.scheduleReconnect(e);
                }
            }

            public void onSuccess(StompSession stompSession) {
                if (AbstractStompSessionManager.this.logger.isDebugEnabled()) {
                    AbstractStompSessionManager.this.logger.debug((Object)"onSuccess");
                }
                AbstractStompSessionManager.this.connected = true;
                AbstractStompSessionManager.this.connecting = false;
                stompSession.setAutoReceipt(AbstractStompSessionManager.this.isAutoReceiptEnabled());
                if (AbstractStompSessionManager.this.applicationEventPublisher != null) {
                    AbstractStompSessionManager.this.applicationEventPublisher.publishEvent((ApplicationEvent)new StompSessionConnectedEvent(this));
                }
                AbstractStompSessionManager.this.reconnectFuture = null;
                latch.countDown();
            }
        });
        try {
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                this.logger.error((Object)"No response to connection attempt");
                if (epoch == this.epoch.get()) {
                    this.scheduleReconnect(null);
                }
            }
        }
        catch (InterruptedException e1) {
            this.logger.error((Object)"Interrupted while waiting for connection attempt");
            Thread.currentThread().interrupt();
        }
    }

    private void scheduleReconnect(Throwable e) {
        this.epoch.incrementAndGet();
        this.connected = false;
        this.connecting = false;
        if (e != null) {
            this.logger.error((Object)("STOMP connect error for " + this), e);
        }
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new StompConnectionFailedEvent(this, e));
        }
        if (this.reconnectFuture != null) {
            this.reconnectFuture.cancel(true);
            this.reconnectFuture = null;
        }
        if (this.stompClient.getTaskScheduler() != null) {
            this.reconnectFuture = this.stompClient.getTaskScheduler().schedule(new Runnable(){

                @Override
                public void run() {
                    AbstractStompSessionManager.this.connect();
                }
            }, new Date(System.currentTimeMillis() + this.recoveryInterval));
        } else {
            this.logger.info((Object)"For automatic reconnection the 'stompClient' should be configured with a TaskScheduler.");
        }
    }

    public void destroy() {
        if (this.stompSessionListenableFuture != null) {
            if (this.reconnectFuture != null) {
                this.reconnectFuture.cancel(false);
                this.reconnectFuture = null;
            }
            this.stompSessionListenableFuture.addCallback((ListenableFutureCallback)new ListenableFutureCallback<StompSession>(){

                public void onFailure(Throwable ex) {
                    AbstractStompSessionManager.this.connected = false;
                }

                public void onSuccess(StompSession session) {
                    session.disconnect();
                    AbstractStompSessionManager.this.connected = false;
                }
            });
            this.stompSessionListenableFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Starting " + this.getClass().getSimpleName()));
                }
                this.connect();
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            if (callback != null) {
                callback.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                this.running = false;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Stopping " + this.getClass().getSimpleName()));
                }
                this.destroy();
            }
        }
    }

    @Override
    public void connect(StompSessionHandler handler) {
        this.compositeStompSessionHandler.addHandler(handler);
        if (!this.isConnected() && !this.connecting) {
            if (this.reconnectFuture != null) {
                this.reconnectFuture.cancel(true);
                this.reconnectFuture = null;
            }
            this.connect();
        }
    }

    @Override
    public void disconnect(StompSessionHandler handler) {
        this.compositeStompSessionHandler.removeHandler(handler);
    }

    protected StompHeaders getConnectHeaders() {
        return this.connectHeaders;
    }

    public String toString() {
        return ObjectUtils.identityToString((Object)this) + " {connecting=" + this.connecting + ", connected=" + this.connected + ", name='" + this.name + '\'' + '}';
    }

    protected abstract ListenableFuture<StompSession> doConnect(StompSessionHandler var1);

    private class CompositeStompSessionHandler
    extends StompSessionHandlerAdapter {
        private final List<StompSessionHandler> delegates = Collections.synchronizedList(new ArrayList());
        private volatile StompSession session;

        private CompositeStompSessionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addHandler(StompSessionHandler delegate) {
            List<StompSessionHandler> list = this.delegates;
            synchronized (list) {
                if (this.session != null) {
                    delegate.afterConnected(this.session, AbstractStompSessionManager.this.getConnectHeaders());
                }
                this.delegates.add(delegate);
            }
        }

        void removeHandler(StompSessionHandler delegate) {
            this.delegates.remove(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterConnected(StompSession session, StompHeaders connectedHeaders) {
            List<StompSessionHandler> list = this.delegates;
            synchronized (list) {
                this.session = session;
                for (StompSessionHandler delegate : this.delegates) {
                    delegate.afterConnected(session, connectedHeaders);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleException(StompSession session, StompCommand command, StompHeaders headers, byte[] payload, Throwable exception) {
            List<StompSessionHandler> list = this.delegates;
            synchronized (list) {
                for (StompSessionHandler delegate : this.delegates) {
                    delegate.handleException(session, command, headers, payload, exception);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleTransportError(StompSession session, Throwable exception) {
            AbstractStompSessionManager.this.logger.error((Object)("STOMP transport error for session: [" + session + "]"), exception);
            this.session = null;
            AbstractStompSessionManager.this.scheduleReconnect(exception);
            List<StompSessionHandler> list = this.delegates;
            synchronized (list) {
                for (StompSessionHandler delegate : this.delegates) {
                    delegate.handleTransportError(session, exception);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleFrame(StompHeaders headers, Object payload) {
            List<StompSessionHandler> list = this.delegates;
            synchronized (list) {
                for (StompSessionHandler delegate : this.delegates) {
                    delegate.handleFrame(headers, payload);
                }
            }
        }
    }
}

