/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stomp.outbound;

import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.stomp.StompSessionManager;
import org.springframework.integration.stomp.event.StompExceptionEvent;
import org.springframework.integration.stomp.event.StompReceiptEvent;
import org.springframework.integration.stomp.support.StompHeaderMapper;
import org.springframework.integration.support.management.ManageableLifecycle;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.stomp.ConnectionLostException;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.messaging.simp.stomp.StompSessionHandlerAdapter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class StompMessageHandler
extends AbstractMessageHandler
implements ApplicationEventPublisherAware,
ManageableLifecycle {
    private static final int DEFAULT_CONNECT_TIMEOUT = 3000;
    private final StompSessionHandler sessionHandler = new IntegrationOutboundStompSessionHandler();
    private final StompSessionManager stompSessionManager;
    private final Semaphore connectSemaphore = new Semaphore(0);
    private HeaderMapper<StompHeaders> headerMapper = new StompHeaderMapper();
    private Expression destinationExpression;
    private EvaluationContext evaluationContext;
    private ApplicationEventPublisher applicationEventPublisher;
    private long connectTimeout = 3000L;
    private volatile StompSession stompSession;
    private volatile Throwable transportError;
    private volatile boolean running;

    public StompMessageHandler(StompSessionManager stompSessionManager) {
        Assert.notNull((Object)stompSessionManager, (String)"'stompSessionManager' is required.");
        this.stompSessionManager = stompSessionManager;
    }

    public void setDestination(String destination) {
        Assert.hasText((String)destination, (String)"'destination' must not be empty.");
        this.destinationExpression = new ValueExpression((Object)destination);
    }

    public void setDestinationExpression(Expression destinationExpression) {
        Assert.notNull((Object)destinationExpression, (String)"'destinationExpression' must not be null.");
        this.destinationExpression = destinationExpression;
    }

    public void setHeaderMapper(HeaderMapper<StompHeaders> headerMapper) {
        Assert.notNull(headerMapper, (String)"'headerMapper' must not be null.");
        this.headerMapper = headerMapper;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected void onInit() {
        super.onInit();
        if (this.evaluationContext == null) {
            this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        }
    }

    protected void handleMessageInternal(Message<?> message) {
        StompSession.Receiptable receiptable;
        try {
            this.connectIfNecessary();
        }
        catch (Exception e) {
            throw new MessageDeliveryException(message, "The '" + (Object)((Object)this) + "' could not deliver message.", (Throwable)e);
        }
        StompSession session = this.stompSession;
        StompHeaders stompHeaders = new StompHeaders();
        this.headerMapper.fromHeaders(message.getHeaders(), (Object)stompHeaders);
        if (stompHeaders.getDestination() == null) {
            Assert.state((this.destinationExpression != null ? 1 : 0) != 0, (String)"One of 'destination' or 'destinationExpression' must be provided, if message header doesn't supply 'destination' STOMP header.");
            String destination = (String)this.destinationExpression.getValue(this.evaluationContext, message, String.class);
            stompHeaders.setDestination(destination);
        }
        if ((receiptable = session.send(stompHeaders, message.getPayload())).getReceiptId() != null) {
            String destination = stompHeaders.getDestination();
            ApplicationEventPublisher eventPublisher = this.applicationEventPublisher;
            if (eventPublisher != null) {
                receiptable.addReceiptTask(() -> {
                    StompReceiptEvent event = new StompReceiptEvent((Object)this, destination, receiptable.getReceiptId(), StompCommand.SEND, false);
                    event.setMessage(message);
                    eventPublisher.publishEvent((ApplicationEvent)event);
                });
            }
            receiptable.addReceiptLostTask(() -> {
                if (eventPublisher != null) {
                    StompReceiptEvent event = new StompReceiptEvent((Object)this, destination, receiptable.getReceiptId(), StompCommand.SEND, true);
                    event.setMessage(message);
                    eventPublisher.publishEvent((ApplicationEvent)event);
                } else {
                    this.logger.error(() -> "The receipt [" + receiptable.getReceiptId() + "] is lost for [" + message + "] on destination [" + destination + "]");
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectIfNecessary() throws InterruptedException {
        Semaphore semaphore = this.connectSemaphore;
        synchronized (semaphore) {
            if (this.stompSession == null || !this.stompSessionManager.isConnected()) {
                this.stompSessionManager.disconnect(this.sessionHandler);
                this.stompSessionManager.connect(this.sessionHandler);
                if (!this.connectSemaphore.tryAcquire(this.connectTimeout, TimeUnit.MILLISECONDS) || this.stompSession == null) {
                    if (this.transportError != null) {
                        if (this.transportError instanceof ConnectionLostException) {
                            throw (ConnectionLostException)this.transportError;
                        }
                        throw new ConnectionLostException(this.transportError.getMessage());
                    }
                    throw new ConnectionLostException("Failed to obtain StompSession during timeout: " + this.connectTimeout);
                }
            }
        }
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        this.running = false;
        this.stompSessionManager.disconnect(this.sessionHandler);
    }

    public boolean isRunning() {
        return this.running;
    }

    private class IntegrationOutboundStompSessionHandler
    extends StompSessionHandlerAdapter {
        IntegrationOutboundStompSessionHandler() {
        }

        public void afterConnected(StompSession session, StompHeaders connectedHeaders) {
            StompMessageHandler.this.transportError = null;
            StompMessageHandler.this.stompSession = session;
            StompMessageHandler.this.connectSemaphore.release();
        }

        public void handleFrame(StompHeaders headers, Object payload) {
            Object thePayload = payload;
            if (thePayload == null) {
                thePayload = headers.getFirst("message");
            }
            if (thePayload != null) {
                Message failedMessage = StompMessageHandler.this.getMessageBuilderFactory().withPayload(thePayload).copyHeaders(StompMessageHandler.this.headerMapper.toHeaders((Object)headers)).build();
                MessageDeliveryException exception = new MessageDeliveryException(failedMessage, "STOMP frame handling error.");
                if (StompMessageHandler.this.applicationEventPublisher != null) {
                    StompMessageHandler.this.applicationEventPublisher.publishEvent((ApplicationEvent)new StompExceptionEvent((Object)StompMessageHandler.this, (Throwable)exception));
                } else {
                    StompMessageHandler.this.logger.getLog().error((Object)exception);
                }
            }
        }

        public void handleException(StompSession session, @Nullable StompCommand command, StompHeaders headers, byte[] payload, Throwable exception) {
            Message failedMessage;
            if (command != null) {
                StompHeaderAccessor stompHeaderAccessor = StompHeaderAccessor.create((StompCommand)command, (Map)headers);
                failedMessage = MessageBuilder.createMessage((Object)payload, (MessageHeaders)stompHeaderAccessor.getMessageHeaders());
            } else {
                failedMessage = MessageBuilder.withPayload((Object)payload).copyHeaders((Map)headers).build();
            }
            StompMessageHandler.this.logger.error(exception, () -> "The exception for session [" + session + "] on message [" + failedMessage + "]");
        }

        public void handleTransportError(StompSession session, Throwable exception) {
            StompMessageHandler.this.transportError = exception;
            StompMessageHandler.this.stompSession = null;
        }
    }
}

