/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stream;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.core.MessageSource;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.Assert;

public class CharacterStreamReadingMessageSource
extends IntegrationObjectSupport
implements MessageSource<String> {
    private final BufferedReader reader;
    private final Object monitor;

    public CharacterStreamReadingMessageSource(Reader reader) {
        this(reader, -1);
    }

    public CharacterStreamReadingMessageSource(Reader reader, int bufferSize) {
        Assert.notNull((Object)reader, (String)"reader must not be null");
        this.monitor = reader;
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : (bufferSize > 0 ? new BufferedReader(reader, bufferSize) : new BufferedReader(reader));
    }

    public String getComponentType() {
        return "stream:stdin-channel-adapter(character)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message<String> receive() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                if (!this.reader.ready()) {
                    return null;
                }
                String line = this.reader.readLine();
                GenericMessage genericMessage = line != null ? new GenericMessage((Object)line) : null;
                return genericMessage;
            }
        }
        catch (IOException e) {
            throw new MessagingException("IO failure occurred in adapter", (Throwable)e);
        }
    }

    public static final CharacterStreamReadingMessageSource stdin() {
        return new CharacterStreamReadingMessageSource(new InputStreamReader(System.in));
    }

    public static final CharacterStreamReadingMessageSource stdin(String charsetName) {
        try {
            return new CharacterStreamReadingMessageSource(new InputStreamReader(System.in, charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("unsupported encoding: " + charsetName, e);
        }
    }
}

