/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.syslog.inbound;

import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.serializer.Deserializer;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpNioServerConnectionFactory;
import org.springframework.integration.ip.tcp.serializer.ByteArrayLfSerializer;
import org.springframework.integration.syslog.inbound.SyslogReceivingChannelAdapterSupport;
import org.springframework.messaging.Message;

public class TcpSyslogReceivingChannelAdapter
extends SyslogReceivingChannelAdapterSupport
implements TcpListener,
ApplicationEventPublisherAware {
    private volatile AbstractServerConnectionFactory connectionFactory;
    private volatile ApplicationEventPublisher applicationEventPublisher;

    public void setConnectionFactory(AbstractServerConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public String getComponentType() {
        return "syslog:inbound-channel-adapter(tcp)";
    }

    @Override
    protected void onInit() {
        super.onInit();
        if (this.connectionFactory == null) {
            this.connectionFactory = new TcpNioServerConnectionFactory(this.getPort());
            this.connectionFactory.setDeserializer((Deserializer)new ByteArrayLfSerializer());
            this.connectionFactory.setBeanFactory(this.getBeanFactory());
            if (this.applicationEventPublisher != null) {
                this.connectionFactory.setApplicationEventPublisher(this.applicationEventPublisher);
            }
            this.connectionFactory.afterPropertiesSet();
        }
        this.connectionFactory.registerListener((TcpListener)this);
    }

    protected void doStart() {
        super.doStart();
        this.connectionFactory.start();
    }

    protected void doStop() {
        super.doStop();
        this.connectionFactory.stop();
    }

    public boolean onMessage(Message<?> message) {
        this.convertAndSend(message);
        return false;
    }
}

