/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.syslog.inbound;

import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.syslog.DefaultMessageConverter;
import org.springframework.integration.syslog.MessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;

public abstract class SyslogReceivingChannelAdapterSupport
extends MessageProducerSupport {
    protected static final int DEFAULT_PORT = 514;
    private volatile int port = 514;
    private MessageConverter converter = new DefaultMessageConverter();
    private boolean converterSet;

    protected int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setConverter(MessageConverter converter) {
        this.converter = converter;
        this.converterSet = true;
    }

    protected void onInit() {
        super.onInit();
        if (!this.converterSet) {
            ((DefaultMessageConverter)this.converter).setBeanFactory(this.getBeanFactory());
        }
    }

    protected void convertAndSend(Message<?> message) {
        try {
            if (message instanceof ErrorMessage) {
                ErrorMessage errorMessage = (ErrorMessage)message;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((CharSequence)("Error on syslog socket:" + ((Throwable)errorMessage.getPayload()).getMessage()));
                }
            } else {
                this.sendMessage(this.converter.fromSyslog(message));
            }
        }
        catch (Exception e) {
            throw new MessagingException(message, "Failed to send Message", (Throwable)e);
        }
    }
}

