/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.mail;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ServerSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Base64Utils;

public final class TestMailServer {
    public static SmtpServer smtp(int port) {
        try {
            return new SmtpServer(port);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Pop3Server pop3(int port) {
        try {
            return new Pop3Server(port);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static ImapServer imap(int port) {
        try {
            return new ImapServer(port);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private TestMailServer() {
    }

    public static abstract class MailServer
    implements Runnable {
        protected final Log LOGGER = LogFactory.getLog(this.getClass());
        protected static final String IO_EXCEPTION = "IOException";
        private final ServerSocket serverSocket;
        private final ExecutorService exec = Executors.newCachedThreadPool();
        protected final Set<String> assertions = new HashSet<String>();
        protected final List<String> messages = new ArrayList<String>();
        private final List<MailHandler> handlers = new ArrayList<MailHandler>();
        private volatile boolean listening;

        MailServer(int port) throws IOException {
            this.serverSocket = ServerSocketFactory.getDefault().createServerSocket(port);
            this.listening = true;
            this.exec.execute(this);
        }

        public int getPort() {
            return this.serverSocket.getLocalPort();
        }

        public boolean isListening() {
            return this.listening;
        }

        public List<String> getMessages() {
            return this.messages;
        }

        public void resetServer() {
            this.assertions.clear();
        }

        public boolean assertReceived(String assertion) {
            return this.assertions.contains(assertion);
        }

        @Override
        public void run() {
            try {
                while (!this.serverSocket.isClosed()) {
                    Socket socket = this.serverSocket.accept();
                    MailHandler mailHandler = this.mailHandler(socket);
                    this.handlers.add(mailHandler);
                    this.exec.execute(mailHandler);
                }
            }
            catch (IOException e) {
                this.listening = false;
            }
        }

        protected abstract MailHandler mailHandler(Socket var1);

        public void stop() {
            try {
                for (MailHandler handler : this.handlers) {
                    handler.stop();
                }
                this.serverSocket.close();
            }
            catch (IOException e) {
                this.LOGGER.error((Object)IO_EXCEPTION, (Throwable)e);
            }
            this.exec.shutdownNow();
        }

        public abstract class MailHandler
        implements Runnable {
            public static final String BODY = "foo\r\n";
            public static final String MESSAGE = "To: Foo <foo@bar>\r\ncc: a@b, c@d\r\nbcc: e@f, g@h\r\nFrom: Bar <bar@baz>, Bar2 <bar2@baz>\r\nSubject: Test Email\r\n\r\nfoo\r\n";
            protected final Socket socket;
            private BufferedWriter writer;
            protected StringBuilder sb = new StringBuilder();
            protected BufferedReader reader;
            protected boolean stopped;

            MailHandler(Socket socket) {
                this.socket = socket;
            }

            @Override
            public void run() {
                try {
                    this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                    this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
                }
                catch (IOException e) {
                    MailServer.this.LOGGER.error((Object)MailServer.IO_EXCEPTION, (Throwable)e);
                }
                this.doRun();
            }

            protected void write(String str) throws IOException {
                this.writer.write(str);
                this.writer.write("\r\n");
                this.writer.flush();
            }

            abstract void doRun();

            void stop() {
                this.stopped = true;
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static class ImapServer
    extends MailServer {
        private volatile boolean seen;
        private volatile boolean idled;

        ImapServer(int port) throws IOException {
            super(port);
        }

        @Override
        public void resetServer() {
            super.resetServer();
            this.seen = false;
            this.idled = false;
        }

        @Override
        protected MailServer.MailHandler mailHandler(Socket socket) {
            return new ImapHandler(socket);
        }

        class ImapHandler
        extends MailServer.MailHandler {
            private static final String OK_FETCH_COMPLETED = "OK FETCH completed";
            private static final int IDLE_WAIT_TIME = 1000;

            ImapHandler(Socket socket) {
                super(socket);
            }

            @Override
            void doRun() {
                block27: {
                    try {
                        String line;
                        this.write("* OK IMAP4rev1 Service Ready");
                        String idleTag = "";
                        while (!this.socket.isClosed() && (line = this.reader.readLine()) != null) {
                            String tag = line.substring(0, line.indexOf(32) + 1);
                            if (line.endsWith("CAPABILITY")) {
                                this.write("* CAPABILITY IDLE IMAP4rev1");
                                this.write(tag + "OK CAPABILITY completed");
                                continue;
                            }
                            if (line.endsWith("LOGIN user pw")) {
                                this.write(tag + "OK LOGIN completed");
                                continue;
                            }
                            if (line.endsWith("LIST \"\" INBOX")) {
                                this.write("* LIST \"/\" \"INBOX\"");
                                this.write(tag + "OK LIST completed");
                                continue;
                            }
                            if (line.endsWith("LIST \"\" \"\"")) {
                                this.write("* LIST \"/\" \"\"");
                                this.write(tag + "OK LIST completed");
                                continue;
                            }
                            if (line.endsWith("SELECT INBOX")) {
                                this.write("* 1 EXISTS");
                                if (!ImapServer.this.seen) {
                                    this.write("* 1 RECENT");
                                    this.write("* OK [UNSEEN 1]");
                                } else {
                                    this.write("* OK");
                                }
                                this.write("* OK [PERMANENTFLAGS (\\Deleted \\Seen \\*)]");
                                this.write(tag + "OK SELECT completed");
                                continue;
                            }
                            if (line.endsWith("EXAMINE INBOX")) {
                                this.write(tag + "OK");
                                continue;
                            }
                            if (line.endsWith("SEARCH FROM bar@baz UNSEEN ALL")) {
                                this.searchReply(tag);
                                continue;
                            }
                            if (line.endsWith("SEARCH NOT (DELETED) NOT (SEEN) NOT (KEYWORD testSIUserFlag) ALL")) {
                                this.searchReply(tag);
                                ImapServer.this.assertions.add("searchWithUserFlag");
                                continue;
                            }
                            if (line.contains("FETCH 1 (ENVELOPE")) {
                                this.write("* 1 FETCH (RFC822.SIZE " + "To: Foo <foo@bar>\r\ncc: a@b, c@d\r\nbcc: e@f, g@h\r\nFrom: Bar <bar@baz>, Bar2 <bar2@baz>\r\nSubject: Test Email\r\n\r\nfoo\r\n".length() + " INTERNALDATE \"27-May-2013 09:45:41 +0000\" FLAGS (\\Seen) ENVELOPE (\"Mon, 27 May 2013 15:14:49 +0530\" \"Test Email\" ((\"Bar\" NIL \"bar\" \"baz\")) ((\"Bar\" NIL \"bar\" \"baz\")) ((\"Bar\" NIL \"bar\" \"baz\")) ((\"Foo\" NIL \"foo\" \"bar\")) ((NIL NIL \"a\" \"b\") (NIL NIL \"c\" \"d\")) ((NIL NIL \"e\" \"f\") (NIL NIL \"g\" \"h\")) \"<4DA0A7E4.3010506@baz.net>\" \"<CACVnpJkAUUfa3d_-4GNZW2WpxbB39tBCHC=T0gc7hty6dOEHcA@foo.bar.com>\") BODYSTRUCTURE (\"TEXT\" \"PLAIN\" (\"CHARSET\" \"ISO-8859-1\") NIL NIL \"7BIT\" 1 5)))");
                                this.write(tag + OK_FETCH_COMPLETED);
                                continue;
                            }
                            if (line.contains("FETCH 2 (BODYSTRUCTURE)")) {
                                this.write("* 2 FETCH BODYSTRUCTURE (\"TEXT\" \"PLAIN\" (\"CHARSET\" \"ISO-8859-1\") NIL NIL \"7BIT\" 1 5)))");
                                this.write(tag + OK_FETCH_COMPLETED);
                                continue;
                            }
                            if (line.contains("STORE 1 +FLAGS (\\Flagged)")) {
                                this.write("* 1 FETCH (FLAGS (\\Flagged))");
                                this.write(tag + "OK STORE completed");
                                continue;
                            }
                            if (line.contains("STORE 1 +FLAGS (\\Seen)")) {
                                this.write("* 1 FETCH (FLAGS (\\Flagged \\Seen))");
                                this.write(tag + "OK STORE completed");
                                ImapServer.this.seen = true;
                                continue;
                            }
                            if (line.contains("FETCH 1 FLAGS")) {
                                this.write("* 1 FLAGS(\\Seen)");
                                this.write(tag + OK_FETCH_COMPLETED);
                                continue;
                            }
                            if (line.contains("FETCH 1 (BODY.PEEK")) {
                                this.write("* 1 FETCH (BODY[]<0> {" + ("To: Foo <foo@bar>\r\ncc: a@b, c@d\r\nbcc: e@f, g@h\r\nFrom: Bar <bar@baz>, Bar2 <bar2@baz>\r\nSubject: Test Email\r\n\r\nfoo\r\n".length() + 2) + "}");
                                this.write("To: Foo <foo@bar>\r\ncc: a@b, c@d\r\nbcc: e@f, g@h\r\nFrom: Bar <bar@baz>, Bar2 <bar2@baz>\r\nSubject: Test Email\r\n\r\nfoo\r\n");
                                this.write(")");
                                this.write(tag + OK_FETCH_COMPLETED);
                                continue;
                            }
                            if (line.contains("CLOSE")) {
                                this.write(tag + "OK CLOSE completed");
                                continue;
                            }
                            if (line.contains("NOOP")) {
                                this.write(tag + "OK NOOP completed");
                                continue;
                            }
                            if (line.endsWith("STORE 1 +FLAGS (testSIUserFlag)")) {
                                this.write(tag + "OK STORE completed");
                                ImapServer.this.assertions.add("storeUserFlag");
                                continue;
                            }
                            if (line.endsWith("IDLE")) {
                                this.write("+ idling");
                                idleTag = tag;
                                if (!ImapServer.this.idled) {
                                    try {
                                        Thread.sleep(1000L);
                                        this.write("* 2 EXISTS");
                                        ImapServer.this.seen = false;
                                    }
                                    catch (InterruptedException e) {
                                        Thread.currentThread().interrupt();
                                    }
                                }
                                ImapServer.this.idled = true;
                                continue;
                            }
                            if (line.equals("DONE")) {
                                this.write(idleTag + "OK");
                                continue;
                            }
                            if (!line.contains("LOGOUT")) continue;
                            this.write(tag + "OK LOGOUT completed");
                            this.socket.close();
                        }
                    }
                    catch (IOException e) {
                        if (this.stopped) break block27;
                        ImapServer.this.LOGGER.error((Object)"IOException", (Throwable)e);
                    }
                }
            }

            void searchReply(String tag) throws IOException {
                if (ImapServer.this.seen) {
                    this.write("* SEARCH");
                } else {
                    this.write("* SEARCH 1");
                }
                this.write(tag + "OK SEARCH completed");
            }
        }
    }

    public static class Pop3Server
    extends MailServer {
        Pop3Server(int port) throws IOException {
            super(port);
        }

        @Override
        protected MailServer.MailHandler mailHandler(Socket socket) {
            return new Pop3Handler(socket);
        }

        class Pop3Handler
        extends MailServer.MailHandler {
            private static final String PLUS_OK = "+OK";

            Pop3Handler(Socket socket) {
                super(socket);
            }

            @Override
            void doRun() {
                block19: {
                    try {
                        String line;
                        this.write("+OK POP3");
                        block18: while (!this.socket.isClosed() && (line = this.reader.readLine()) != null) {
                            switch (line) {
                                case "CAPA": {
                                    this.write(PLUS_OK);
                                    this.write("USER");
                                    this.write(".");
                                    continue block18;
                                }
                                case "USER user": 
                                case "PASS pw": 
                                case "NOOP": {
                                    this.write(PLUS_OK);
                                    continue block18;
                                }
                                case "STAT": {
                                    this.write("+OK 1 3");
                                    continue block18;
                                }
                                case "RETR 1": {
                                    this.write(PLUS_OK);
                                    this.write("To: Foo <foo@bar>\r\ncc: a@b, c@d\r\nbcc: e@f, g@h\r\nFrom: Bar <bar@baz>, Bar2 <bar2@baz>\r\nSubject: Test Email\r\n\r\nfoo\r\n");
                                    this.write(".");
                                    continue block18;
                                }
                                case "QUIT": {
                                    this.write(PLUS_OK);
                                    this.socket.close();
                                    continue block18;
                                }
                            }
                            throw new UnsupportedOperationException(line);
                        }
                    }
                    catch (IOException e) {
                        if (this.stopped) break block19;
                        Pop3Server.this.LOGGER.error((Object)"IOException", (Throwable)e);
                    }
                }
            }
        }
    }

    public static class SmtpServer
    extends MailServer {
        SmtpServer(int port) throws IOException {
            super(port);
        }

        @Override
        protected MailServer.MailHandler mailHandler(Socket socket) {
            return new SmtpHandler(socket);
        }

        class SmtpHandler
        extends MailServer.MailHandler {
            SmtpHandler(Socket socket) {
                super(socket);
            }

            @Override
            void doRun() {
                block12: {
                    try {
                        String line;
                        this.write("220 foo SMTP");
                        while (!this.socket.isClosed() && (line = this.reader.readLine()) != null) {
                            if (line.contains("EHLO")) {
                                this.write("250-foo hello [0,0,0,0], foo");
                                this.write("250-AUTH LOGIN PLAIN");
                                this.write("250 OK");
                                continue;
                            }
                            if (line.contains("MAIL FROM")) {
                                this.write("250 OK");
                                continue;
                            }
                            if (line.contains("RCPT TO")) {
                                this.write("250 OK");
                                continue;
                            }
                            if (line.contains("AUTH LOGIN")) {
                                this.write("334 VXNlcm5hbWU6");
                                continue;
                            }
                            if (line.contains("dXNlcg==")) {
                                this.sb.append("user:");
                                this.sb.append(new String(Base64Utils.decode((byte[])line.getBytes())));
                                this.sb.append("\n");
                                this.write("334 UGFzc3dvcmQ6");
                                continue;
                            }
                            if (line.contains("cHc=")) {
                                this.sb.append("password:");
                                this.sb.append(new String(Base64Utils.decode((byte[])line.getBytes())));
                                this.sb.append("\n");
                                this.write("235");
                                continue;
                            }
                            if (line.equals("DATA")) {
                                this.write("354");
                                continue;
                            }
                            if (line.equals(".")) {
                                this.write("250");
                                continue;
                            }
                            if (line.equals("QUIT")) {
                                this.write("221");
                                this.socket.close();
                                continue;
                            }
                            this.sb.append(line);
                            this.sb.append("\n");
                        }
                        SmtpServer.this.messages.add(this.sb.toString());
                    }
                    catch (IOException e) {
                        if (this.stopped) break block12;
                        SmtpServer.this.LOGGER.error((Object)"IOException", (Throwable)e);
                    }
                }
            }
        }
    }
}

