/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ErrorHandler;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class TestUtils {
    private static final Log LOGGER = LogFactory.getLog(TestUtils.class);

    public static Object getPropertyValue(Object root, String propertyPath) {
        Object value = null;
        DirectFieldAccessor accessor = new DirectFieldAccessor(root);
        String[] tokens = propertyPath.split("\\.");
        for (int i = 0; i < tokens.length; ++i) {
            value = accessor.getPropertyValue(tokens[i]);
            if (value == null) {
                if (i == tokens.length - 1) {
                    return null;
                }
                throw new IllegalArgumentException("intermediate property '" + tokens[i] + "' is null");
            }
            accessor = new DirectFieldAccessor(value);
        }
        return value;
    }

    public static <T> T getPropertyValue(Object root, String propertyPath, Class<T> type) {
        Object value = TestUtils.getPropertyValue(root, propertyPath);
        if (value != null) {
            Assert.isAssignable(type, value.getClass());
        }
        return (T)value;
    }

    public static TestApplicationContext createTestApplicationContext() {
        TestApplicationContext context = new TestApplicationContext();
        MessagePublishingErrorHandler errorHandler = new MessagePublishingErrorHandler(context);
        ThreadPoolTaskScheduler scheduler = TestUtils.createTaskScheduler(10);
        scheduler.setErrorHandler((ErrorHandler)errorHandler);
        TestUtils.registerBean("taskScheduler", scheduler, (BeanFactory)context);
        TestUtils.registerBean("integrationConversionService", new DefaultFormattingConversionService(), (BeanFactory)context);
        TestUtils.registerBean("errorChannel", (message, timeout) -> {
            LOGGER.error((Object)message);
            return true;
        }, (BeanFactory)context);
        return context;
    }

    public static ThreadPoolTaskScheduler createTaskScheduler(int poolSize) {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(poolSize);
        scheduler.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        scheduler.afterPropertiesSet();
        return scheduler;
    }

    private static void registerBean(String beanName, Object bean, BeanFactory beanFactory) {
        Assert.notNull((Object)beanName, (String)"bean name must not be null");
        Assert.isInstanceOf(GenericApplicationContext.class, (Object)beanFactory, (String)"beanFactory must be an instance of GenericApplicationContext");
        GenericApplicationContext applicationContext = (GenericApplicationContext)beanFactory;
        applicationContext.registerBean(beanName, bean.getClass(), () -> bean, new BeanDefinitionCustomizer[0]);
    }

    public static Properties locateComponentInHistory(List<Properties> history, String componentName, int startingIndex) {
        Assert.notNull(history, (String)"'history' must not be null");
        Assert.isTrue((boolean)StringUtils.hasText((String)componentName), (String)"'componentName' must be provided");
        Assert.isTrue((startingIndex < history.size() ? 1 : 0) != 0, (String)"'startingIndex' can not be greater then size of history");
        Properties component = null;
        for (int i = startingIndex; i < history.size(); ++i) {
            Properties properties = history.get(i);
            if (!componentName.equals(properties.get("name"))) continue;
            component = properties;
            break;
        }
        return component;
    }

    public static String applySystemFileSeparator(String s) {
        return s.replaceAll("/", Matcher.quoteReplacement(File.separator));
    }

    public static LevelsContainer adjustLogLevels(String methodName, List<Class<?>> classes, List<String> categories, Level level) {
        LoggerConfig specificConfig;
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        HashMap classLevels = new HashMap();
        for (Class<?> cls : classes) {
            String className = cls.getName();
            specificConfig = TestUtils.addLoggerConfigForCategory(config, className);
            classLevels.put(cls, specificConfig.getLevel());
            specificConfig.setLevel(level);
        }
        HashMap<String, Level> categoryLevels = new HashMap<String, Level>();
        for (String category : categories) {
            specificConfig = TestUtils.addLoggerConfigForCategory(config, category);
            categoryLevels.put(category, specificConfig.getLevel());
            specificConfig.setLevel(level);
        }
        ctx.updateLoggers();
        LOGGER.warn((Object)("++++++++++++++++++++++++++++ Overridden log level setting for: " + classes + " and " + categories + " for test " + methodName));
        return new LevelsContainer(classLevels, categoryLevels);
    }

    private static LoggerConfig addLoggerConfigForCategory(Configuration config, String category) {
        LoggerConfig loggerConfig;
        LoggerConfig specificConfig = loggerConfig = config.getLoggerConfig(category);
        if (!loggerConfig.getName().equals(category)) {
            specificConfig = new LoggerConfig(category, loggerConfig.getLevel(), true);
            specificConfig.setParent(loggerConfig);
            config.addLogger(category, specificConfig);
        }
        return specificConfig;
    }

    public static void revertLogLevels(String methodName, LevelsContainer container) {
        LOGGER.warn((Object)("++++++++++++++++++++++++++++ Restoring log level setting for: " + container.classLevels.keySet() + " and " + container.categoryLevels.keySet() + " for test " + methodName));
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        container.classLevels.forEach((key, value) -> {
            LoggerConfig loggerConfig = config.getLoggerConfig(key.getName());
            loggerConfig.setLevel(value);
        });
        container.categoryLevels.forEach((key, value) -> {
            LoggerConfig loggerConfig = config.getLoggerConfig(key);
            loggerConfig.setLevel(value);
        });
        ctx.updateLoggers();
    }

    public static class TestApplicationContext
    extends GenericApplicationContext {
        TestApplicationContext() {
        }

        public void registerChannel(@Nullable String channelNameArg, MessageChannel channel) {
            String channelName = channelNameArg;
            String componentName = this.getComponentNameIfNamed(channel);
            if (componentName != null) {
                if (channelName == null) {
                    channelName = componentName;
                } else {
                    Assert.isTrue((boolean)componentName.equals(channelName), (String)"channel name has already been set with a conflicting value");
                }
            }
            TestUtils.registerBean(channelName, channel, (BeanFactory)this);
        }

        public void registerEndpoint(String endpointName, Object endpoint) {
            TestUtils.registerBean(endpointName, endpoint, (BeanFactory)this);
        }

        public void registerBean(String beanName, Object bean) {
            TestUtils.registerBean(beanName, bean, (BeanFactory)this);
        }

        private String getComponentNameIfNamed(MessageChannel channel) {
            Set interfaces = ClassUtils.getAllInterfacesAsSet((Object)channel);
            AtomicReference componentName = new AtomicReference();
            for (Class intface : interfaces) {
                if (!"org.springframework.integration.support.context.NamedComponent".equals(intface.getName())) continue;
                ReflectionUtils.doWithMethods(channel.getClass(), method -> {
                    try {
                        componentName.set((String)method.invoke((Object)channel, new Object[0]));
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalArgumentException(e);
                    }
                }, method -> method.getName().equals("getComponentName"));
                break;
            }
            return (String)componentName.get();
        }
    }

    private static class MessagePublishingErrorHandler
    implements ErrorHandler {
        private final Log logger = LogFactory.getLog(this.getClass());
        private final TestApplicationContext context;

        MessagePublishingErrorHandler(TestApplicationContext ctx) {
            this.context = ctx;
        }

        public void handleError(Throwable throwable) {
            boolean sent;
            block6: {
                MessageChannel errorChannel = this.resolveErrorChannel(throwable);
                sent = false;
                if (errorChannel != null) {
                    try {
                        sent = errorChannel.send((Message)new ErrorMessage(throwable), 10000L);
                    }
                    catch (Throwable errorDeliveryError) {
                        this.logger.warn((Object)"Error message was not delivered.", errorDeliveryError);
                        if (!(errorDeliveryError instanceof Error)) break block6;
                        throw (Error)errorDeliveryError;
                    }
                }
            }
            if (!sent && this.logger.isErrorEnabled()) {
                Message failedMessage;
                Message message = failedMessage = throwable instanceof MessagingException ? ((MessagingException)throwable).getFailedMessage() : null;
                if (failedMessage != null) {
                    this.logger.error((Object)("failure occurred in messaging task with message: " + failedMessage), throwable);
                } else {
                    this.logger.error((Object)"failure occurred in messaging task", throwable);
                }
            }
        }

        private MessageChannel resolveErrorChannel(Throwable t) {
            if (t instanceof MessagingException) {
                Message failedMessage = ((MessagingException)t).getFailedMessage();
                if (failedMessage == null) {
                    return null;
                }
                Object errorChannelHeader = failedMessage.getHeaders().getErrorChannel();
                if (errorChannelHeader instanceof MessageChannel) {
                    return (MessageChannel)errorChannelHeader;
                }
                if (errorChannelHeader instanceof String) {
                    return (MessageChannel)this.context.getBean((String)errorChannelHeader, MessageChannel.class);
                }
                throw new IllegalStateException("Unsupported error channel header type. Expected MessageChannel or String, but actual header is [" + errorChannelHeader + "]");
            }
            return null;
        }
    }

    public static class LevelsContainer {
        private final Map<Class<?>, Level> classLevels;
        private final Map<String, Level> categoryLevels;

        public LevelsContainer(Map<Class<?>, Level> classLevels, Map<String, Level> categoryLevels) {
            this.classLevels = classLevels;
            this.categoryLevels = categoryLevels;
        }
    }
}

