/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.support;

import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.integration.test.support.RequestResponseScenario;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public abstract class AbstractRequestResponseScenarioTests {
    private List<RequestResponseScenario> scenarios = null;
    @Autowired
    private ApplicationContext applicationContext;

    @Before
    public void setUp() {
        this.scenarios = this.defineRequestResponseScenarios();
    }

    @Test
    public void testRequestResponseScenarios() {
        int i = 1;
        for (RequestResponseScenario scenario : this.scenarios) {
            Object name = scenario.getName() == null ? "scenario-" + i++ : scenario.getName();
            scenario.init();
            MessageChannel inputChannel = (MessageChannel)this.applicationContext.getBean(scenario.getInputChannelName(), MessageChannel.class);
            MessageChannel outputChannel = (MessageChannel)this.applicationContext.getBean(scenario.getOutputChannelName(), MessageChannel.class);
            if (outputChannel instanceof SubscribableChannel) {
                ((SubscribableChannel)outputChannel).subscribe(scenario.getResponseValidator());
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)inputChannel.send(scenario.getMessage())).as((String)name + ": message not sent on " + scenario.getInputChannelName(), new Object[0])).isTrue();
            if (outputChannel instanceof PollableChannel) {
                Message response = ((PollableChannel)outputChannel).receive(10000L);
                ((ObjectAssert)Assertions.assertThat((Object)response).as((String)name + ": receive timeout on " + scenario.getOutputChannelName(), new Object[0])).isNotNull();
                scenario.getResponseValidator().handleMessage(response);
            }
            ((ObjectAssert)Assertions.assertThat(scenario.getResponseValidator().getLastMessage()).as("message was not handled on " + outputChannel + " for scenario '" + (String)name + "'.", new Object[0])).isNotNull();
            if (!(outputChannel instanceof SubscribableChannel)) continue;
            ((SubscribableChannel)outputChannel).unsubscribe(scenario.getResponseValidator());
        }
    }

    protected abstract List<RequestResponseScenario> defineRequestResponseScenarios();
}

