/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.webflux.inbound;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.integration.http.config.HttpContextUtils;
import org.springframework.integration.http.inbound.BaseHttpInboundEndpoint;
import org.springframework.integration.http.inbound.CrossOrigin;
import org.springframework.integration.http.inbound.RequestMapping;
import org.springframework.integration.webflux.inbound.WebFluxInboundEndpoint;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.reactive.result.condition.NameValueExpression;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;

public class WebFluxIntegrationRequestMappingHandlerMapping
extends RequestMappingHandlerMapping
implements ApplicationListener<ContextRefreshedEvent>,
DestructionAwareBeanPostProcessor {
    private static final Method HANDLER_METHOD = ReflectionUtils.findMethod(WebHandler.class, (String)"handle", (Class[])new Class[]{ServerWebExchange.class});
    private final AtomicBoolean initialized = new AtomicBoolean();

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.initialized.get() && this.isHandler(bean.getClass())) {
            this.detectHandlerMethods(bean);
        }
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (this.isHandler(bean.getClass())) {
            this.unregisterMapping(this.getMappingForEndpoint((WebFluxInboundEndpoint)((Object)bean)));
        }
    }

    public boolean requiresDestruction(Object bean) {
        return this.isHandler(bean.getClass());
    }

    protected boolean isHandler(Class<?> beanType) {
        return WebFluxInboundEndpoint.class.isAssignableFrom(beanType);
    }

    protected void detectHandlerMethods(Object handler) {
        RequestMappingInfo mapping;
        if (handler instanceof String) {
            handler = this.getApplicationContext().getBean((String)handler);
        }
        if ((mapping = this.getMappingForEndpoint((WebFluxInboundEndpoint)((Object)handler))) != null) {
            this.registerMapping(mapping, handler, HANDLER_METHOD);
        }
    }

    private RequestMappingInfo getMappingForEndpoint(WebFluxInboundEndpoint endpoint) {
        org.springframework.web.bind.annotation.RequestMapping requestMappingAnnotation = HttpContextUtils.convertRequestMappingToAnnotation((RequestMapping)endpoint.getRequestMapping());
        if (requestMappingAnnotation != null) {
            return this.createRequestMappingInfo(requestMappingAnnotation, this.getCustomTypeCondition(((Object)((Object)endpoint)).getClass()));
        }
        return null;
    }

    protected CorsConfiguration initCorsConfiguration(Object handler, Method method, RequestMappingInfo mappingInfo) {
        CrossOrigin crossOrigin = ((BaseHttpInboundEndpoint)handler).getCrossOrigin();
        if (crossOrigin != null) {
            CorsConfiguration config = new CorsConfiguration();
            for (String string : crossOrigin.getOrigin()) {
                config.addAllowedOrigin(string);
            }
            for (String string : crossOrigin.getMethod()) {
                config.addAllowedMethod(string.name());
            }
            for (String string : crossOrigin.getAllowedHeaders()) {
                config.addAllowedHeader(string);
            }
            for (String string : crossOrigin.getExposedHeaders()) {
                config.addExposedHeader(string);
            }
            if (crossOrigin.getAllowCredentials() != null) {
                config.setAllowCredentials(crossOrigin.getAllowCredentials());
            }
            if (crossOrigin.getMaxAge() != -1L) {
                config.setMaxAge(Long.valueOf(crossOrigin.getMaxAge()));
            }
            if (CollectionUtils.isEmpty((Collection)config.getAllowedMethods())) {
                for (RequestMethod allowedMethod : mappingInfo.getMethodsCondition().getMethods()) {
                    config.addAllowedMethod(allowedMethod.name());
                }
            }
            if (CollectionUtils.isEmpty((Collection)config.getAllowedHeaders())) {
                for (NameValueExpression headerExpression : mappingInfo.getHeadersCondition().getExpressions()) {
                    if (headerExpression.isNegated()) continue;
                    config.addAllowedHeader(headerExpression.getName());
                }
            }
            return config.applyPermitDefaultValues();
        }
        return null;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().equals(this.getApplicationContext()) && !this.initialized.getAndSet(true)) {
            super.afterPropertiesSet();
        }
    }

    public void afterPropertiesSet() {
    }
}

