/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.websocket.support;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpAttributesContextHolder;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.messaging.SubProtocolHandler;

public class PassThruSubProtocolHandler
implements SubProtocolHandler {
    final List<String> supportedProtocols = new ArrayList<String>();

    public void setSupportedProtocols(String ... supportedProtocols) {
        Assert.noNullElements((Object[])supportedProtocols, (String)"'supportedProtocols' must not be empty");
        this.supportedProtocols.addAll(Arrays.asList(supportedProtocols));
    }

    public List<String> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessageFromClient(WebSocketSession session, WebSocketMessage<?> webSocketMessage, MessageChannel outputChannel) throws Exception {
        SimpMessageHeaderAccessor headerAccessor = SimpMessageHeaderAccessor.create((SimpMessageType)SimpMessageType.MESSAGE);
        headerAccessor.setSessionId(session.getId());
        headerAccessor.setSessionAttributes(session.getAttributes());
        headerAccessor.setUser(session.getPrincipal());
        headerAccessor.setHeader("content-length", (Object)webSocketMessage.getPayloadLength());
        headerAccessor.setLeaveMutable(true);
        Message message = MessageBuilder.createMessage((Object)webSocketMessage.getPayload(), (MessageHeaders)headerAccessor.getMessageHeaders());
        try {
            SimpAttributesContextHolder.setAttributesFromMessage((Message)message);
            outputChannel.send(message);
        }
        finally {
            SimpAttributesContextHolder.resetAttributes();
        }
    }

    public void handleMessageToClient(WebSocketSession session, Message<?> message) throws Exception {
        Object payload = message.getPayload();
        if (payload instanceof String) {
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)((String)payload)));
        } else if (payload instanceof byte[]) {
            session.sendMessage((WebSocketMessage)new TextMessage((byte[])payload));
        } else if (payload instanceof ByteBuffer) {
            session.sendMessage((WebSocketMessage)new TextMessage(((ByteBuffer)payload).array()));
        } else {
            throw new IllegalArgumentException("Unsupported payload type: " + payload.getClass() + ". Can be one of: " + Arrays.asList(String.class, byte[].class, ByteBuffer.class));
        }
    }

    public String resolveSessionId(Message<?> message) {
        return SimpMessageHeaderAccessor.getSessionId((Map)message.getHeaders());
    }

    public void afterSessionStarted(WebSocketSession session, MessageChannel outputChannel) throws Exception {
    }

    public void afterSessionEnded(WebSocketSession session, CloseStatus closeStatus, MessageChannel outputChannel) throws Exception {
    }
}

