/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.websocket.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.integration.config.IntegrationConfigurationInitializer;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.socket.config.annotation.DelegatingWebSocketConfiguration;
import org.springframework.web.socket.config.annotation.ServletWebSocketHandlerRegistry;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

public class WebSocketIntegrationConfigurationInitializer
implements IntegrationConfigurationInitializer {
    private static final Log LOGGER = LogFactory.getLog(WebSocketIntegrationConfigurationInitializer.class);
    private static final boolean SERVLET_PRESENT = ClassUtils.isPresent((String)"javax.servlet.Servlet", (ClassLoader)WebSocketIntegrationConfigurationInitializer.class.getClassLoader());
    private static final String WEB_SOCKET_HANDLER_MAPPING_BEAN_NAME = "integrationWebSocketHandlerMapping";

    public void initialize(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof BeanDefinitionRegistry) {
            this.registerEnableWebSocketIfNecessary((BeanDefinitionRegistry)beanFactory);
        } else {
            LOGGER.warn((Object)"'DelegatingWebSocketConfiguration' isn't registered because 'beanFactory' isn't an instance of `BeanDefinitionRegistry`.");
        }
    }

    private void registerEnableWebSocketIfNecessary(BeanDefinitionRegistry registry) {
        if (SERVLET_PRESENT) {
            if (!registry.containsBeanDefinition("defaultSockJsTaskScheduler")) {
                BeanDefinitionBuilder sockJsTaskSchedulerBuilder = BeanDefinitionBuilder.genericBeanDefinition(ThreadPoolTaskScheduler.class).addPropertyValue("threadNamePrefix", (Object)"SockJS-").addPropertyValue("poolSize", (Object)Runtime.getRuntime().availableProcessors()).addPropertyValue("removeOnCancelPolicy", (Object)true);
                registry.registerBeanDefinition("defaultSockJsTaskScheduler", (BeanDefinition)sockJsTaskSchedulerBuilder.getBeanDefinition());
            }
            if (!registry.containsBeanDefinition(DelegatingWebSocketConfiguration.class.getName()) && !registry.containsBeanDefinition(WEB_SOCKET_HANDLER_MAPPING_BEAN_NAME)) {
                BeanDefinitionBuilder enableWebSocketBuilder = BeanDefinitionBuilder.genericBeanDefinition(WebSocketHandlerMappingFactoryBean.class).setRole(2).addPropertyReference("sockJsTaskScheduler", "defaultSockJsTaskScheduler");
                registry.registerBeanDefinition(WEB_SOCKET_HANDLER_MAPPING_BEAN_NAME, (BeanDefinition)enableWebSocketBuilder.getBeanDefinition());
            }
        }
    }

    private static class IntegrationServletWebSocketHandlerRegistry
    extends ServletWebSocketHandlerRegistry {
        IntegrationServletWebSocketHandlerRegistry() {
        }

        public boolean requiresTaskScheduler() {
            return super.requiresTaskScheduler();
        }

        public void setTaskScheduler(TaskScheduler scheduler) {
            super.setTaskScheduler(scheduler);
        }
    }

    private static class WebSocketHandlerMappingFactoryBean
    extends AbstractFactoryBean<HandlerMapping>
    implements ApplicationContextAware {
        private final IntegrationServletWebSocketHandlerRegistry registry = new IntegrationServletWebSocketHandlerRegistry();
        private ThreadPoolTaskScheduler sockJsTaskScheduler;
        private ApplicationContext applicationContext;

        private WebSocketHandlerMappingFactoryBean() {
        }

        public void setSockJsTaskScheduler(ThreadPoolTaskScheduler sockJsTaskScheduler) {
            this.sockJsTaskScheduler = sockJsTaskScheduler;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }

        protected HandlerMapping createInstance() {
            BeanFactory beanFactory = this.getBeanFactory();
            if (beanFactory != null) {
                ((ListableBeanFactory)beanFactory).getBeansOfType(WebSocketConfigurer.class).values().forEach(configurer -> configurer.registerWebSocketHandlers((WebSocketHandlerRegistry)this.registry));
            }
            if (this.registry.requiresTaskScheduler()) {
                this.registry.setTaskScheduler((TaskScheduler)this.sockJsTaskScheduler);
            }
            AbstractHandlerMapping handlerMapping = this.registry.getHandlerMapping();
            handlerMapping.setApplicationContext(this.applicationContext);
            return handlerMapping;
        }

        public Class<?> getObjectType() {
            return HandlerMapping.class;
        }
    }
}

