/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.springframework.integration.ws.AbstractWebServiceOutboundGateway;
import org.springframework.integration.ws.MarshallingWebServiceOutboundGateway;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.SourceExtractor;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceMessageExtractor;
import org.springframework.ws.client.support.destination.DestinationProvider;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.StringSource;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.w3c.dom.Document;

public class SimpleWebServiceOutboundGateway
extends AbstractWebServiceOutboundGateway {
    private final SourceExtractor<?> sourceExtractor;

    public SimpleWebServiceOutboundGateway(DestinationProvider destinationProvider) {
        this(destinationProvider, null, null);
    }

    public SimpleWebServiceOutboundGateway(DestinationProvider destinationProvider, SourceExtractor<?> sourceExtractor) {
        this(destinationProvider, sourceExtractor, (WebServiceMessageFactory)null);
    }

    public SimpleWebServiceOutboundGateway(DestinationProvider destinationProvider, SourceExtractor<?> sourceExtractor, WebServiceMessageFactory messageFactory) {
        super(destinationProvider, messageFactory);
        this.sourceExtractor = sourceExtractor != null ? sourceExtractor : new DefaultSourceExtractor();
    }

    public SimpleWebServiceOutboundGateway(String uri) {
        this(uri, null, null);
    }

    public SimpleWebServiceOutboundGateway(String uri, SourceExtractor<?> sourceExtractor) {
        this(uri, sourceExtractor, (WebServiceMessageFactory)null);
    }

    public SimpleWebServiceOutboundGateway(String uri, SourceExtractor<?> sourceExtractor, WebServiceMessageFactory messageFactory) {
        super(uri, messageFactory);
        this.sourceExtractor = sourceExtractor != null ? sourceExtractor : new DefaultSourceExtractor();
    }

    public String getComponentType() {
        return "ws:outbound-gateway(simple)";
    }

    @Override
    protected Object doHandle(String uri, Message<?> requestMessage, WebServiceMessageCallback requestCallback) {
        Object requestPayload = requestMessage.getPayload();
        Object responseResultInstance = null;
        if (requestPayload instanceof String) {
            responseResultInstance = new StringResult();
        } else if (requestPayload instanceof Document) {
            responseResultInstance = new DOMResult();
        }
        return this.getWebServiceTemplate().sendAndReceive(uri, (WebServiceMessageCallback)new SimpleRequestMessageCallback(requestCallback, requestMessage), (WebServiceMessageExtractor)new SimpleResponseMessageExtractor((Result)responseResultInstance));
    }

    private static class DefaultSourceExtractor
    extends TransformerObjectSupport
    implements SourceExtractor<DOMSource> {
        private DefaultSourceExtractor() {
        }

        public DOMSource extractData(Source source) throws IOException, TransformerException {
            if (source instanceof DOMSource) {
                return (DOMSource)source;
            }
            DOMResult result = new DOMResult();
            this.transform(source, result);
            return new DOMSource(result.getNode());
        }
    }

    private final class SimpleResponseMessageExtractor
    extends AbstractWebServiceOutboundGateway.ResponseMessageExtractor {
        private final Result result;

        private SimpleResponseMessageExtractor(Result result) {
            super(SimpleWebServiceOutboundGateway.this);
            this.result = result;
        }

        @Override
        public Object doExtractData(WebServiceMessage message) throws IOException, TransformerException {
            Source payloadSource = message.getPayloadSource();
            if (payloadSource != null && this.result != null) {
                this.transform(payloadSource, this.result);
                if (this.result instanceof StringResult) {
                    return this.result.toString();
                }
                if (this.result instanceof DOMResult) {
                    return ((DOMResult)this.result).getNode();
                }
                return this.result;
            }
            return payloadSource;
        }
    }

    private final class SimpleRequestMessageCallback
    extends AbstractWebServiceOutboundGateway.RequestMessageCallback {
        private SimpleRequestMessageCallback(WebServiceMessageCallback requestCallback, Message<?> requestMessage) {
            super(SimpleWebServiceOutboundGateway.this, requestCallback, requestMessage);
        }

        @Override
        public void doWithMessageInternal(WebServiceMessage message, Object payload) throws IOException, TransformerException {
            Source source = this.extractSource(payload);
            this.transform(source, message.getPayloadResult());
        }

        private Source extractSource(Object requestPayload) throws IOException, TransformerException {
            Source source = null;
            if (requestPayload instanceof Source) {
                source = (Source)requestPayload;
                Object o = SimpleWebServiceOutboundGateway.this.sourceExtractor.extractData(source);
                Assert.isInstanceOf(Source.class, (Object)o);
                source = (Source)o;
            } else if (requestPayload instanceof String) {
                source = new StringSource((String)requestPayload);
            } else if (requestPayload instanceof Document) {
                source = new DOMSource((Document)requestPayload);
            } else {
                throw new MessagingException("Unsupported payload type '" + requestPayload.getClass() + "'. " + ((Object)((Object)this)).getClass().getName() + " only supports 'java.lang.String', '" + Source.class.getName() + "', and '" + Document.class.getName() + "'. Consider either using the '" + MarshallingWebServiceOutboundGateway.class.getName() + "' or a Message Transformer.");
            }
            return source;
        }
    }
}

