/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.config;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractTransformerParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.xml.config.XmlNamespaceUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class XsltPayloadTransformerParser
extends AbstractTransformerParser {
    protected String getTransformerClassName() {
        return "org.springframework.integration.xml.transformer.XsltPayloadTransformer";
    }

    protected void parseTransformer(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List xslParameterElements;
        boolean resultFactorySpecified;
        String xslResource = element.getAttribute("xsl-resource");
        String xslTemplates = element.getAttribute("xsl-templates");
        String resultTransformer = element.getAttribute("result-transformer");
        String resultFactory = element.getAttribute("result-factory");
        String resultType = element.getAttribute("result-type");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"xslt-param-headers");
        Assert.isTrue((boolean)(StringUtils.hasText((String)xslResource) ^ StringUtils.hasText((String)xslTemplates)), (String)"Exactly one of 'xsl-resource' or 'xsl-templates' is required.");
        if (StringUtils.hasText((String)xslResource)) {
            builder.addConstructorArgValue((Object)xslResource);
        } else if (StringUtils.hasText((String)xslTemplates)) {
            builder.addConstructorArgReference(xslTemplates);
        }
        XmlNamespaceUtils.configureResultFactory(builder, resultType, resultFactory);
        boolean bl = resultFactorySpecified = StringUtils.hasText((String)resultFactory) || StringUtils.hasText((String)resultType);
        if (resultFactorySpecified) {
            builder.addPropertyValue("alwaysUseResultFactory", (Object)true);
        }
        if (StringUtils.hasText((String)resultTransformer)) {
            builder.addConstructorArgReference(resultTransformer);
        }
        if (!CollectionUtils.isEmpty((Collection)(xslParameterElements = DomUtils.getChildElementsByTagName((Element)element, (String)"xslt-param")))) {
            ManagedMap xslParameterMappings = new ManagedMap();
            for (Element xslParameterElement : xslParameterElements) {
                String name = xslParameterElement.getAttribute("name");
                String expression = xslParameterElement.getAttribute("expression");
                String value = xslParameterElement.getAttribute("value");
                Assert.isTrue((boolean)(StringUtils.hasText((String)expression) ^ StringUtils.hasText((String)value)), (String)"Exactly one of 'expression' or 'value' is required.");
                RootBeanDefinition expressionDef = null;
                if (StringUtils.hasText((String)value)) {
                    expressionDef = new RootBeanDefinition("org.springframework.expression.common.LiteralExpression");
                    expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)value);
                } else if (StringUtils.hasText((String)expression)) {
                    expressionDef = new RootBeanDefinition("org.springframework.integration.config.ExpressionFactoryBean");
                    expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)expression);
                }
                if (expressionDef == null) continue;
                xslParameterMappings.put(name, expressionDef);
            }
            builder.addPropertyValue("xslParameterMappings", (Object)xslParameterMappings);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"source-factory");
    }
}

