/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.transformer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.VfsResource;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.xml.result.ResultFactory;
import org.springframework.integration.xml.source.DomSourceFactory;
import org.springframework.integration.xml.source.SourceFactory;
import org.springframework.integration.xml.transformer.AbstractXmlTransformer;
import org.springframework.integration.xml.transformer.ResultTransformer;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.StringSource;
import org.springframework.xml.transform.TransformerFactoryUtils;
import org.w3c.dom.Document;

public class XsltPayloadTransformer
extends AbstractXmlTransformer
implements BeanClassLoaderAware {
    private final ResultTransformer resultTransformer;
    private final Resource xslResource;
    private Templates templates;
    private String transformerFactoryClassName;
    private volatile StandardEvaluationContext evaluationContext;
    private Map<String, Expression> xslParameterMappings;
    private SourceFactory sourceFactory = new DomSourceFactory();
    private boolean resultFactoryExplicitlySet;
    private boolean alwaysUseSourceFactory = false;
    private boolean alwaysUseResultFactory = false;
    private String[] xsltParamHeaders;
    private static final Class<?> SERVLET_CONTEXT_RESOURCE_CLASS;
    private ClassLoader classLoader;

    public XsltPayloadTransformer(Templates templates) {
        this(templates, null);
    }

    public XsltPayloadTransformer(Templates templates, ResultTransformer resultTransformer) {
        Assert.notNull((Object)templates, (String)"'templates' must not be null.");
        this.templates = templates;
        this.resultTransformer = resultTransformer;
        this.xslResource = null;
    }

    public XsltPayloadTransformer(Resource xslResource) {
        this(xslResource, null, null);
    }

    public XsltPayloadTransformer(Resource xslResource, ResultTransformer resultTransformer) {
        this(xslResource, resultTransformer, null);
    }

    public XsltPayloadTransformer(Resource xslResource, String transformerFactoryClassName) {
        this(xslResource, null, transformerFactoryClassName);
    }

    public XsltPayloadTransformer(Resource xslResource, ResultTransformer resultTransformer, String transformerFactoryClassName) {
        Assert.notNull((Object)xslResource, (String)"'xslResource' must not be null.");
        Assert.isTrue((xslResource instanceof ClassPathResource || xslResource instanceof FileSystemResource || xslResource instanceof VfsResource || SERVLET_CONTEXT_RESOURCE_CLASS != null && SERVLET_CONTEXT_RESOURCE_CLASS.isInstance(xslResource) ? 1 : 0) != 0, (String)"Only 'ClassPathResource', 'FileSystemResource', 'ServletContextResource' or 'VfsResource' are supported directly in this transformer. For any other 'Resource' implementations consider to use a 'Templates'-based constructor instantiation.");
        this.xslResource = xslResource;
        this.resultTransformer = resultTransformer;
        this.transformerFactoryClassName = transformerFactoryClassName;
    }

    public void setSourceFactory(SourceFactory sourceFactory) {
        Assert.notNull((Object)sourceFactory, (String)"SourceFactory must not be null");
        this.sourceFactory = sourceFactory;
    }

    @Override
    public void setResultFactory(ResultFactory resultFactory) {
        super.setResultFactory(resultFactory);
        this.resultFactoryExplicitlySet = true;
    }

    public void setAlwaysUseSourceFactory(boolean alwaysUseSourceFactory) {
        this.alwaysUseSourceFactory = alwaysUseSourceFactory;
    }

    public void setAlwaysUseResultFactory(boolean alwaysUseResultFactory) {
        this.alwaysUseResultFactory = alwaysUseResultFactory;
    }

    public void setXslParameterMappings(Map<String, Expression> xslParameterMappings) {
        this.xslParameterMappings = xslParameterMappings;
    }

    public void setXsltParamHeaders(String ... xsltParamHeaders) {
        Assert.notNull((Object)xsltParamHeaders, (String)"'xsltParamHeaders' must not be null.");
        this.xsltParamHeaders = Arrays.copyOf(xsltParamHeaders, xsltParamHeaders.length);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, (String)"'beanClassLoader' must not be null.");
        this.classLoader = classLoader;
    }

    @Override
    public void setResultType(String resultType) {
        super.setResultType(resultType);
        if (StringUtils.hasText((String)resultType)) {
            this.alwaysUseResultFactory = true;
        }
    }

    @Override
    public void setResultFactoryName(String resultFactoryName) {
        super.setResultFactoryName(resultFactoryName);
        if (StringUtils.hasText((String)resultFactoryName)) {
            this.alwaysUseResultFactory = true;
        }
    }

    public String getComponentType() {
        return "xml:xslt-transformer";
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        if (this.templates == null) {
            try {
                TransformerFactory transformerFactory = this.createTransformerFactory();
                this.templates = transformerFactory.newTemplates(XsltPayloadTransformer.createStreamSourceOnResource(this.xslResource));
            }
            catch (IOException | ClassNotFoundException | TransformerConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private TransformerFactory createTransformerFactory() throws ClassNotFoundException {
        TransformerFactory transformerFactory;
        block4: {
            if (this.transformerFactoryClassName != null) {
                Class transformerFactoryClass = ClassUtils.forName((String)this.transformerFactoryClassName, (ClassLoader)this.classLoader);
                transformerFactory = TransformerFactoryUtils.newInstance((Class)transformerFactoryClass);
            } else {
                transformerFactory = TransformerFactoryUtils.newInstance();
            }
            try {
                transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "file,jar:file");
            }
            catch (IllegalArgumentException ex) {
                if (!this.logger.isInfoEnabled()) break block4;
                this.logger.info((CharSequence)("The 'http://javax.xml.XMLConstants/property/accessExternalStylesheet' property is not supported by " + transformerFactory.getClass().getCanonicalName()));
            }
        }
        return transformerFactory;
    }

    protected Object doTransform(Message<?> message) {
        try {
            Transformer transformer = this.buildTransformer(message);
            Object payload = this.alwaysUseSourceFactory ? this.sourceFactory.createSource(message.getPayload()) : message.getPayload();
            Object transformedPayload = null;
            transformedPayload = this.alwaysUseResultFactory ? this.transformUsingResultFactory(payload, transformer) : (payload instanceof String ? this.transformString((String)payload, transformer) : (payload instanceof Document ? this.transformDocument((Document)payload, transformer) : (payload instanceof Source ? this.transformSource((Source)payload, payload, transformer) : this.transformUsingResultFactory(payload, transformer))));
            return transformedPayload;
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    private Object transformUsingResultFactory(Object payload, Transformer transformer) throws TransformerException {
        Object source = this.alwaysUseSourceFactory ? this.sourceFactory.createSource(payload) : (payload instanceof String ? new StringSource((String)payload) : (payload instanceof Document ? new DOMSource((Document)payload) : (payload instanceof Source ? (Source)payload : this.sourceFactory.createSource(payload))));
        return this.transformSource((Source)source, payload, transformer);
    }

    private Object transformSource(Source source, Object payload, Transformer transformer) throws TransformerException {
        Result result = !this.resultFactoryExplicitlySet && "text".equals(transformer.getOutputProperties().getProperty("method")) ? new StringResult() : this.getResultFactory().createResult(payload);
        transformer.transform(source, result);
        if (this.resultTransformer != null) {
            return this.resultTransformer.transformResult(result);
        }
        return result;
    }

    private String transformString(String stringPayload, Transformer transformer) throws TransformerException {
        StringResult result = new StringResult();
        Source source = this.alwaysUseSourceFactory ? this.sourceFactory.createSource(stringPayload) : new StringSource(stringPayload);
        transformer.transform(source, (Result)result);
        return result.toString();
    }

    private Document transformDocument(Document documentPayload, Transformer transformer) throws TransformerException {
        Source source = this.alwaysUseSourceFactory ? this.sourceFactory.createSource(documentPayload) : new DOMSource(documentPayload);
        Result result = this.getResultFactory().createResult(documentPayload);
        if (!DOMResult.class.isAssignableFrom(result.getClass())) {
            throw new MessagingException("Document to Document conversion requires a DOMResult-producing ResultFactory implementation.");
        }
        DOMResult domResult = (DOMResult)result;
        transformer.transform(source, domResult);
        return (Document)domResult.getNode();
    }

    private Transformer buildTransformer(Message<?> message) throws TransformerException {
        Transformer transformer = this.templates.newTransformer();
        if (this.xslParameterMappings != null) {
            for (Map.Entry<String, Expression> entry : this.xslParameterMappings.entrySet()) {
                String parameterName = entry.getKey();
                Expression expression = entry.getValue();
                try {
                    Object value = expression.getValue((EvaluationContext)this.evaluationContext, message);
                    transformer.setParameter(parameterName, value);
                }
                catch (Exception e) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn((CharSequence)("Evaluation of header expression '" + expression.getExpressionString() + "' failed. The XSLT parameter '" + parameterName + "' will be skipped."));
                }
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.xsltParamHeaders)) {
            for (Map.Entry<String, Object> entry : message.getHeaders().entrySet()) {
                String headerName = entry.getKey();
                if (!PatternMatchUtils.simpleMatch((String[])this.xsltParamHeaders, (String)headerName)) continue;
                transformer.setParameter(headerName, entry.getValue());
            }
        }
        return transformer;
    }

    private static StreamSource createStreamSourceOnResource(Resource xslResource) throws IOException {
        try {
            String systemId = xslResource.getURI().toString();
            return new StreamSource(xslResource.getInputStream(), systemId);
        }
        catch (IOException e) {
            return new StreamSource(xslResource.getInputStream());
        }
    }

    static {
        Class aClass = null;
        try {
            aClass = ClassUtils.forName((String)"org.springframework.web.context.support.ServletContextResource", (ClassLoader)ClassUtils.getDefaultClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            SERVLET_CONTEXT_RESOURCE_CLASS = aClass;
        }
    }
}

