/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.transformer;

import java.io.IOException;
import javax.xml.transform.Result;
import org.springframework.integration.xml.transformer.AbstractXmlTransformer;
import org.springframework.integration.xml.transformer.ResultTransformer;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.oxm.Marshaller;
import org.springframework.util.Assert;

public class MarshallingTransformer
extends AbstractXmlTransformer {
    private final Marshaller marshaller;
    private final ResultTransformer resultTransformer;
    private volatile boolean extractPayload = true;

    public MarshallingTransformer(Marshaller marshaller, ResultTransformer resultTransformer) {
        Assert.notNull((Object)marshaller, (String)"a marshaller is required");
        this.marshaller = marshaller;
        this.resultTransformer = resultTransformer;
    }

    public MarshallingTransformer(Marshaller marshaller) {
        this(marshaller, null);
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public String getComponentType() {
        return "xml:marshalling-transformer";
    }

    public Object doTransform(Message<?> message) {
        Object transformedPayload;
        Object source = this.extractPayload ? message.getPayload() : message;
        Result result = this.getResultFactory().createResult(source);
        if (result == null) {
            throw new MessagingException("Unable to marshal payload, ResultFactory returned null.");
        }
        try {
            this.marshaller.marshal(source, result);
            transformedPayload = result;
        }
        catch (IOException e) {
            throw new MessagingException("Failed to marshal payload", (Throwable)e);
        }
        if (this.resultTransformer != null) {
            transformedPayload = this.resultTransformer.transformResult(result);
        }
        return transformedPayload;
    }
}

