/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zookeeper.config;

import java.util.UUID;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.leader.Candidate;
import org.springframework.integration.leader.DefaultCandidate;
import org.springframework.integration.leader.event.DefaultLeaderEventPublisher;
import org.springframework.integration.leader.event.LeaderEventPublisher;
import org.springframework.integration.zookeeper.leader.LeaderInitiator;

public class LeaderInitiatorFactoryBean
implements FactoryBean<LeaderInitiator>,
SmartLifecycle,
InitializingBean,
ApplicationEventPublisherAware {
    private CuratorFramework client;
    private Candidate candidate;
    private String path;
    private LeaderInitiator leaderInitiator;
    private boolean autoStartup = true;
    private int phase = 2147482647;
    private ApplicationEventPublisher applicationEventPublisher;
    private LeaderEventPublisher leaderEventPublisher;

    public LeaderInitiatorFactoryBean setClient(CuratorFramework client) {
        this.client = client;
        return this;
    }

    public LeaderInitiatorFactoryBean setPath(String path) {
        this.path = path;
        return this;
    }

    public LeaderInitiatorFactoryBean setRole(String role) {
        this.candidate = new DefaultCandidate(UUID.randomUUID().toString(), role);
        return this;
    }

    public void setLeaderEventPublisher(LeaderEventPublisher leaderEventPublisher) {
        this.leaderEventPublisher = leaderEventPublisher;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public boolean isAutoStartup() {
        return this.leaderInitiator != null && this.leaderInitiator.isAutoStartup();
    }

    public void start() {
        if (this.leaderInitiator != null) {
            this.leaderInitiator.start();
        }
    }

    public void stop() {
        if (this.leaderInitiator != null) {
            this.leaderInitiator.stop();
        }
    }

    public void stop(Runnable callback) {
        if (this.leaderInitiator != null) {
            this.leaderInitiator.stop(callback);
        } else {
            callback.run();
        }
    }

    public boolean isRunning() {
        return this.leaderInitiator != null && this.leaderInitiator.isRunning();
    }

    public int getPhase() {
        if (this.leaderInitiator != null) {
            return this.leaderInitiator.getPhase();
        }
        return this.phase;
    }

    public void afterPropertiesSet() {
        if (this.leaderInitiator == null) {
            this.leaderInitiator = new LeaderInitiator(this.client, this.candidate, this.path);
            this.leaderInitiator.setPhase(this.phase);
            this.leaderInitiator.setAutoStartup(this.autoStartup);
            if (this.leaderEventPublisher != null) {
                this.leaderInitiator.setLeaderEventPublisher(this.leaderEventPublisher);
            } else if (this.applicationEventPublisher != null) {
                this.leaderInitiator.setLeaderEventPublisher((LeaderEventPublisher)new DefaultLeaderEventPublisher(this.applicationEventPublisher));
            }
        }
    }

    public synchronized LeaderInitiator getObject() {
        return this.leaderInitiator;
    }

    public Class<?> getObjectType() {
        return LeaderInitiator.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

