/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.core;

import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.core.AbstractBeanMethodProcessor;
import org.springframework.config.java.core.BeanNameTrackingDefaultListableBeanFactory;
import org.springframework.config.java.core.EnhancerMethodInvoker;
import org.springframework.config.java.core.MethodBeanWrapper;
import org.springframework.config.java.naming.BeanNamingStrategy;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardBeanMethodProcessor
extends AbstractBeanMethodProcessor {
    private static final Log log = LogFactory.getLog(StandardBeanMethodProcessor.class);
    private final ConfigurableListableBeanFactory owningBeanFactory;
    private final BeanNamingStrategy namingStrategy;
    private final BeanNameTrackingDefaultListableBeanFactory childTrackingFactory;
    private final MethodBeanWrapper beanWrapper;

    public StandardBeanMethodProcessor(ConfigurableListableBeanFactory owningBeanFactory, BeanNameTrackingDefaultListableBeanFactory childFactory, BeanNamingStrategy namingStrategy, MethodBeanWrapper beanWrapper) {
        super(Bean.class);
        Assert.notNull((Object)owningBeanFactory, (String)"owningBeanFactory is required");
        Assert.notNull((Object)((Object)childFactory));
        Assert.notNull((Object)namingStrategy);
        Assert.notNull((Object)beanWrapper);
        this.owningBeanFactory = owningBeanFactory;
        this.childTrackingFactory = childFactory;
        this.namingStrategy = namingStrategy;
        this.beanWrapper = beanWrapper;
    }

    private StandardBeanMethodProcessor() {
        super(Bean.class);
        this.owningBeanFactory = null;
        this.childTrackingFactory = null;
        this.namingStrategy = null;
        this.beanWrapper = null;
    }

    @Override
    public Object processMethod(Method targetMethod) {
        throw new UnsupportedOperationException("not implemented");
    }

    public String getBeanName(Method m) {
        return this.namingStrategy.getBeanName(m);
    }

    boolean isCurrentlyInCreation(String beanName) {
        return this.owningBeanFactory.isCurrentlyInCreation(beanName) || this.childTrackingFactory.isCurrentlyInCreation(beanName);
    }

    public Object createNewOrGetCachedSingletonBean(String beanName, EnhancerMethodInvoker callback) {
        if (this.isCurrentlyInCreation(beanName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(beanName + " currenty in creation, created one"));
            }
            try {
                return this.beanWrapper.wrapResult(beanName, callback);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(beanName + " not in creation, asked the BF for one"));
        }
        return this.childTrackingFactory.getBean(beanName);
    }

    public static boolean isBeanCreationMethod(Method candidateMethod) {
        return new StandardBeanMethodProcessor().understands(candidateMethod);
    }

    public static Collection<Method> findBeanCreationMethods(Class<?> configurationClass) {
        return new StandardBeanMethodProcessor().findMatchingMethods(configurationClass);
    }
}

