/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.enhancement.cglib;

import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.springframework.config.java.core.BeanMethodProcessor;
import org.springframework.config.java.valuesource.ValueResolutionException;

class ExternalValueMethodMethodInterceptor
implements MethodInterceptor {
    private final BeanMethodProcessor beanMethodProcessor;

    public ExternalValueMethodMethodInterceptor(BeanMethodProcessor beanMethodProcessor) {
        this.beanMethodProcessor = beanMethodProcessor;
    }

    public Object intercept(Object o, Method m, Object[] args, MethodProxy mp) throws Throwable {
        try {
            return this.beanMethodProcessor.processMethod(m);
        }
        catch (ValueResolutionException ve) {
            try {
                return mp.invokeSuper(o, args);
            }
            catch (AbstractMethodError ex) {
                throw ve;
            }
        }
    }
}

