/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.naming;

import java.lang.reflect.Method;
import org.springframework.config.java.naming.BeanNamingStrategy;
import org.springframework.util.Assert;

public class MethodNameStrategy
implements BeanNamingStrategy {
    private Prefix prefix = Prefix.NONE;

    public MethodNameStrategy() {
    }

    public MethodNameStrategy(Prefix prefix) {
        this.prefix = prefix;
    }

    public String getBeanName(Method beanCreationMethod) {
        Assert.notNull((Object)beanCreationMethod, (String)"beanCreationMethod is required");
        String name = beanCreationMethod.getName();
        Class<?> enclosingClass = beanCreationMethod.getDeclaringClass();
        switch (this.prefix) {
            case CLASS: {
                name = enclosingClass.getSimpleName().concat(".").concat(name);
                break;
            }
            case FQN: {
                name = enclosingClass.getName().concat(".").concat(name);
                break;
            }
        }
        return name;
    }

    public void setPrefix(Prefix prefix) {
        this.prefix = prefix;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Prefix {
        NONE(0),
        CLASS(1),
        FQN(2);

        private final int value;

        private Prefix(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

