/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.test.context;

import java.io.StringReader;
import java.util.Properties;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.kafka.test.context.EmbeddedKafka;
import org.springframework.kafka.test.rule.KafkaEmbedded;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class EmbeddedKafkaContextCustomizer
implements ContextCustomizer {
    private final EmbeddedKafka embeddedKafka;

    EmbeddedKafkaContextCustomizer(EmbeddedKafka embeddedKafka) {
        this.embeddedKafka = embeddedKafka;
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        Assert.isInstanceOf(DefaultSingletonBeanRegistry.class, (Object)beanFactory);
        KafkaEmbedded kafkaEmbedded = new KafkaEmbedded(this.embeddedKafka.count(), this.embeddedKafka.controlledShutdown(), this.embeddedKafka.partitions(), this.embeddedKafka.topics());
        Properties properties = new Properties();
        for (String pair : this.embeddedKafka.brokerProperties()) {
            if (!StringUtils.hasText((String)pair)) continue;
            try {
                properties.load(new StringReader(pair));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to load broker property from [" + pair + "]", ex);
            }
        }
        kafkaEmbedded.brokerProperties(properties);
        beanFactory.initializeBean((Object)kafkaEmbedded, "kafkaEmbedded");
        beanFactory.registerSingleton("kafkaEmbedded", (Object)kafkaEmbedded);
        ((DefaultSingletonBeanRegistry)beanFactory).registerDisposableBean("kafkaEmbedded", (DisposableBean)kafkaEmbedded);
    }
}

