/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.test.rule;

import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class Log4j2LevelAdjuster
implements MethodRule {
    private static final Log logger = LogFactory.getLog(Log4j2LevelAdjuster.class);
    private final Class<?>[] classes;
    private final Level level;
    private final String[] categories;

    private Log4j2LevelAdjuster(Level level) {
        this(level, null, new String[]{"org.springframework.integration"});
    }

    private Log4j2LevelAdjuster(Level level, Class<?>[] classes, String[] categories) {
        Assert.notNull((Object)level, (String)"'level' must be null");
        this.level = level;
        this.classes = classes != null ? classes : new Class[]{};
        Stream<String> categoryStream = Stream.of(this.getClass().getPackage().getName());
        if (!ObjectUtils.isEmpty((Object[])categories)) {
            categoryStream = Stream.concat(Arrays.stream(categories), categoryStream);
        }
        this.categories = (String[])categoryStream.toArray(String[]::new);
    }

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        return new AdjusterStatement(base, method);
    }

    public Log4j2LevelAdjuster classes(Class<?> ... classes) {
        return this.classes(false, classes);
    }

    public Log4j2LevelAdjuster classes(boolean merge, Class<?> ... classes) {
        return new Log4j2LevelAdjuster(this.level, merge ? (Class[])Stream.of(this.classes, classes).flatMap(Stream::of).toArray(Class[]::new) : classes, this.categories);
    }

    public Log4j2LevelAdjuster categories(String ... categories) {
        return this.categories(false, categories);
    }

    public Log4j2LevelAdjuster categories(boolean merge, String ... categories) {
        return new Log4j2LevelAdjuster(this.level, this.classes, merge ? (String[])Stream.of(this.categories, categories).flatMap(Stream::of).toArray(String[]::new) : categories);
    }

    public static Log4j2LevelAdjuster trace() {
        return Log4j2LevelAdjuster.forLevel(Level.TRACE);
    }

    public static Log4j2LevelAdjuster debug() {
        return Log4j2LevelAdjuster.forLevel(Level.DEBUG);
    }

    public static Log4j2LevelAdjuster info() {
        return Log4j2LevelAdjuster.forLevel(Level.INFO);
    }

    public static Log4j2LevelAdjuster forLevel(Level level) {
        return new Log4j2LevelAdjuster(level);
    }

    private class AdjusterStatement
    extends Statement {
        private final Statement base;
        private final FrameworkMethod method;

        AdjusterStatement(Statement base, FrameworkMethod method) {
            this.base = base;
            this.method = method;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            LoggerConfig specificConfig;
            LoggerConfig loggerConfig;
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = ctx.getConfiguration();
            HashMap<Class, Level> classLevels = new HashMap<Class, Level>();
            for (Class cls : Log4j2LevelAdjuster.this.classes) {
                String string = cls.getName();
                specificConfig = loggerConfig = config.getLoggerConfig(string);
                if (!loggerConfig.getName().equals(string)) {
                    specificConfig = new LoggerConfig(string, Log4j2LevelAdjuster.this.level, true);
                    specificConfig.setParent(loggerConfig);
                    config.addLogger(string, specificConfig);
                }
                classLevels.put(cls, specificConfig.getLevel());
                specificConfig.setLevel(Log4j2LevelAdjuster.this.level);
            }
            HashMap<String, Level> categoryLevels = new HashMap<String, Level>();
            for (String string : Log4j2LevelAdjuster.this.categories) {
                specificConfig = loggerConfig = config.getLoggerConfig(string);
                if (!loggerConfig.getName().equals(string)) {
                    specificConfig = new LoggerConfig(string, Log4j2LevelAdjuster.this.level, true);
                    specificConfig.setParent(loggerConfig);
                    config.addLogger(string, specificConfig);
                }
                categoryLevels.put(string, specificConfig.getLevel());
                specificConfig.setLevel(Log4j2LevelAdjuster.this.level);
            }
            ctx.updateLoggers();
            logger.debug((Object)("++++++++++++++++++++++++++++ Overridden log level setting for: " + Arrays.toString(Log4j2LevelAdjuster.this.classes) + " and " + Arrays.toString(Log4j2LevelAdjuster.this.categories) + " for test " + this.method.getName()));
            try {
                this.base.evaluate();
            }
            finally {
                logger.debug((Object)("++++++++++++++++++++++++++++ Restoring log level setting for: " + Arrays.toString(Log4j2LevelAdjuster.this.classes) + " and " + Arrays.toString(Log4j2LevelAdjuster.this.categories) + " for test " + this.method.getName()));
                for (Class clazz : Log4j2LevelAdjuster.this.classes) {
                    loggerConfig = config.getLoggerConfig(clazz.getName());
                    loggerConfig.setLevel((Level)classLevels.get(clazz));
                }
                for (String string : Log4j2LevelAdjuster.this.categories) {
                    loggerConfig = config.getLoggerConfig(string);
                    loggerConfig.setLevel((Level)categoryLevels.get(string));
                }
                ctx.updateLoggers();
            }
        }
    }
}

