/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import java.lang.reflect.Type;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.KafkaNull;
import org.springframework.kafka.support.converter.KafkaMessageHeaders;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;

public class MessagingMessageConverter
implements RecordMessageConverter {
    private boolean generateMessageId = false;
    private boolean generateTimestamp = false;

    public void setGenerateMessageId(boolean generateMessageId) {
        this.generateMessageId = generateMessageId;
    }

    public void setGenerateTimestamp(boolean generateTimestamp) {
        this.generateTimestamp = generateTimestamp;
    }

    @Override
    public Message<?> toMessage(ConsumerRecord<?, ?> record, Acknowledgment acknowledgment, Type type) {
        KafkaMessageHeaders kafkaMessageHeaders = new KafkaMessageHeaders(this.generateMessageId, this.generateTimestamp);
        Map<String, Object> rawHeaders = kafkaMessageHeaders.getRawHeaders();
        rawHeaders.put("kafka_receivedMessageKey", record.key());
        rawHeaders.put("kafka_receivedTopic", record.topic());
        rawHeaders.put("kafka_receivedPartitionId", record.partition());
        rawHeaders.put("kafka_offset", record.offset());
        if (acknowledgment != null) {
            rawHeaders.put("kafka_acknowledgment", acknowledgment);
        }
        return MessageBuilder.createMessage((Object)this.extractAndConvertValue(record, type), (MessageHeaders)kafkaMessageHeaders);
    }

    @Override
    public ProducerRecord<?, ?> fromMessage(Message<?> message, String defaultTopic) {
        MessageHeaders headers = message.getHeaders();
        String topic = (String)headers.get((Object)"kafka_topic", String.class);
        Integer partition = (Integer)headers.get((Object)"kafka_partitionId", Integer.class);
        Object key = headers.get((Object)"kafka_messageKey");
        Object payload = this.convertPayload(message);
        return new ProducerRecord(topic == null ? defaultTopic : topic, partition, key, payload);
    }

    protected Object convertPayload(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof KafkaNull) {
            return null;
        }
        return payload;
    }

    protected Object extractAndConvertValue(ConsumerRecord<?, ?> record, Type type) {
        return record.value() == null ? KafkaNull.INSTANCE : record.value();
    }
}

