/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.core.MethodParameter;
import org.springframework.kafka.KafkaException;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;

public class DelegatingInvocableHandler {
    private final List<InvocableHandlerMethod> handlers;
    private final ConcurrentMap<Class<?>, InvocableHandlerMethod> cachedHandlers = new ConcurrentHashMap();
    private final Object bean;

    public DelegatingInvocableHandler(List<InvocableHandlerMethod> handlers, Object bean) {
        this.handlers = new ArrayList<InvocableHandlerMethod>(handlers);
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    public Object invoke(Message<?> message, Object ... providedArgs) throws Exception {
        Class<?> payloadClass = message.getPayload().getClass();
        InvocableHandlerMethod handler = this.getHandlerForPayload(payloadClass);
        return handler.invoke(message, providedArgs);
    }

    protected InvocableHandlerMethod getHandlerForPayload(Class<? extends Object> payloadClass) {
        InvocableHandlerMethod handler = (InvocableHandlerMethod)this.cachedHandlers.get(payloadClass);
        if (handler == null) {
            handler = this.findHandlerForPayload(payloadClass);
            if (handler == null) {
                throw new KafkaException("No method found for " + payloadClass);
            }
            this.cachedHandlers.putIfAbsent(payloadClass, handler);
        }
        return handler;
    }

    protected InvocableHandlerMethod findHandlerForPayload(Class<? extends Object> payloadClass) {
        InvocableHandlerMethod result = null;
        for (InvocableHandlerMethod handler : this.handlers) {
            if (!this.matchHandlerMethod(payloadClass, handler)) continue;
            if (result != null) {
                throw new KafkaException("Ambiguous methods for payload type: " + payloadClass + ": " + result.getMethod().getName() + " and " + handler.getMethod().getName());
            }
            result = handler;
        }
        return result;
    }

    protected boolean matchHandlerMethod(Class<? extends Object> payloadClass, InvocableHandlerMethod handler) {
        MethodParameter methodParameter;
        Method method = handler.getMethod();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length == 1 && ((methodParameter = new MethodParameter(method, 0)).getParameterAnnotations().length == 0 || !methodParameter.hasParameterAnnotation(Header.class)) && methodParameter.getParameterType().isAssignableFrom(payloadClass)) {
            return true;
        }
        boolean foundCandidate = false;
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            MethodParameter methodParameter2 = new MethodParameter(method, i);
            if (methodParameter2.getParameterAnnotations().length != 0 && methodParameter2.hasParameterAnnotation(Header.class) || !methodParameter2.getParameterType().isAssignableFrom(payloadClass)) continue;
            if (foundCandidate) {
                throw new KafkaException("Ambiguous payload parameter for " + method.toGenericString());
            }
            foundCandidate = true;
        }
        return foundCandidate;
    }

    public String getMethodNameFor(Object payload) {
        InvocableHandlerMethod handlerForPayload = this.getHandlerForPayload(payload.getClass());
        return handlerForPayload == null ? "no match" : handlerForPayload.getMethod().toGenericString();
    }
}

