/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.listener.ConsumerSeekAware;

public abstract class AbstractMessageListenerAdapter<K, V, T>
implements ConsumerSeekAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final T delegate;
    private final ConsumerSeekAware seekAware;

    public AbstractMessageListenerAdapter(T delegate) {
        this.delegate = delegate;
        this.seekAware = delegate instanceof ConsumerSeekAware ? (ConsumerSeekAware)delegate : null;
    }

    @Override
    public void registerSeekCallback(ConsumerSeekAware.ConsumerSeekCallback callback) {
        if (this.seekAware != null) {
            this.seekAware.registerSeekCallback(callback);
        }
    }

    @Override
    public void onPartitionsAssigned(Map<TopicPartition, Long> assignments, ConsumerSeekAware.ConsumerSeekCallback callback) {
        if (this.seekAware != null) {
            this.seekAware.onPartitionsAssigned(assignments, callback);
        }
    }

    @Override
    public void onIdleContainer(Map<TopicPartition, Long> assignments, ConsumerSeekAware.ConsumerSeekCallback callback) {
        if (this.seekAware != null) {
            this.seekAware.onIdleContainer(assignments, callback);
        }
    }
}

