/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.kafka.listener.BatchErrorHandler;

public class BatchLoggingErrorHandler
implements BatchErrorHandler {
    private static final Log log = LogFactory.getLog(BatchLoggingErrorHandler.class);

    @Override
    public void handle(Exception thrownException, ConsumerRecords<?, ?> data) {
        StringBuilder message = new StringBuilder("Error while processing:\n");
        if (data == null) {
            message.append("null ");
        } else {
            Iterator iterator = data.iterator();
            while (iterator.hasNext()) {
                message.append(iterator.next()).append('\n');
            }
        }
        log.error((Object)message.substring(0, message.length() - 1), (Throwable)thrownException);
    }
}

