/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.kafka.config.MethodKafkaListenerEndpoint;
import org.springframework.kafka.listener.adapter.DelegatingInvocableHandler;
import org.springframework.kafka.listener.adapter.HandlerAdapter;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;

public class MultiMethodKafkaListenerEndpoint<K, V>
extends MethodKafkaListenerEndpoint<K, V> {
    private final List<Method> methods;
    private final Method defaultMethod;

    public MultiMethodKafkaListenerEndpoint(List<Method> methods, Object bean) {
        this(methods, null, bean);
    }

    public MultiMethodKafkaListenerEndpoint(List<Method> methods, @Nullable Method defaultMethod, Object bean) {
        this.methods = methods;
        this.defaultMethod = defaultMethod;
        this.setBean(bean);
    }

    @Override
    protected HandlerAdapter configureListenerAdapter(MessagingMessageListenerAdapter<K, V> messageListener) {
        ArrayList<InvocableHandlerMethod> invocableHandlerMethods = new ArrayList<InvocableHandlerMethod>();
        InvocableHandlerMethod defaultHandler = null;
        for (Method method : this.methods) {
            InvocableHandlerMethod handler = this.getMessageHandlerMethodFactory().createInvocableHandlerMethod(this.getBean(), method);
            invocableHandlerMethods.add(handler);
            if (!method.equals(this.defaultMethod)) continue;
            defaultHandler = handler;
        }
        DelegatingInvocableHandler delegatingHandler = new DelegatingInvocableHandler(invocableHandlerMethods, defaultHandler, this.getBean(), this.getResolver(), this.getBeanExpressionContext(), this.getBeanFactory());
        return new HandlerAdapter(delegatingHandler);
    }
}

