/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.ExtendedSerializer;
import org.springframework.kafka.support.converter.AbstractJavaTypeMapper;
import org.springframework.kafka.support.converter.DefaultJackson2JavaTypeMapper;
import org.springframework.kafka.support.converter.Jackson2JavaTypeMapper;
import org.springframework.util.Assert;

public class JsonSerializer<T>
implements ExtendedSerializer<T> {
    public static final String ADD_TYPE_INFO_HEADERS = "spring.json.add.type.headers";
    protected final ObjectMapper objectMapper;
    protected boolean addTypeInfo = true;
    protected Jackson2JavaTypeMapper typeMapper = new DefaultJackson2JavaTypeMapper();
    private boolean typeMapperExplicitlySet = false;

    public JsonSerializer() {
        this(new ObjectMapper());
        this.objectMapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public JsonSerializer(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null.");
        this.objectMapper = objectMapper;
    }

    public boolean isAddTypeInfo() {
        return this.addTypeInfo;
    }

    public void setAddTypeInfo(boolean addTypeInfo) {
        this.addTypeInfo = addTypeInfo;
    }

    public Jackson2JavaTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void setTypeMapper(Jackson2JavaTypeMapper typeMapper) {
        Assert.notNull((Object)typeMapper, (String)"'typeMapper' cannot be null");
        this.typeMapper = typeMapper;
        this.typeMapperExplicitlySet = true;
    }

    public void setUseTypeMapperForKey(boolean isKey) {
        if (!this.typeMapperExplicitlySet && this.getTypeMapper() instanceof AbstractJavaTypeMapper) {
            AbstractJavaTypeMapper typeMapper = (AbstractJavaTypeMapper)((Object)this.getTypeMapper());
            typeMapper.setUseForKey(isKey);
        }
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.setUseTypeMapperForKey(isKey);
        if (configs.containsKey(ADD_TYPE_INFO_HEADERS)) {
            Object config = configs.get(ADD_TYPE_INFO_HEADERS);
            if (config instanceof Boolean) {
                this.addTypeInfo = (Boolean)config;
            } else if (config instanceof String) {
                this.addTypeInfo = Boolean.valueOf((String)config);
            } else {
                throw new IllegalStateException("spring.json.add.type.headers must be Boolean or String");
            }
        }
    }

    public byte[] serialize(String topic, Headers headers, T data) {
        if (data == null) {
            return null;
        }
        if (this.addTypeInfo && headers != null) {
            this.typeMapper.fromJavaType(this.objectMapper.constructType(data.getClass()), headers);
        }
        return this.serialize(topic, data);
    }

    public byte[] serialize(String topic, T data) {
        if (data == null) {
            return null;
        }
        try {
            byte[] result = null;
            if (data != null) {
                result = this.objectMapper.writeValueAsBytes(data);
            }
            return result;
        }
        catch (IOException ex) {
            throw new SerializationException("Can't serialize data [" + data + "] for topic [" + topic + "]", (Throwable)ex);
        }
    }

    public void close() {
    }
}

