/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.ExtendedDeserializer;
import org.springframework.kafka.support.serializer.DeserializationException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ErrorHandlingDeserializer2<T>
implements ExtendedDeserializer<T> {
    public static final String KEY_DESERIALIZER_EXCEPTION_HEADER_PREFIX = "springDeserializerException";
    public static final String KEY_DESERIALIZER_EXCEPTION_HEADER = "springDeserializerExceptionKey";
    public static final String VALUE_DESERIALIZER_EXCEPTION_HEADER = "springDeserializerExceptionValue";
    public static final String KEY_FUNCTION = "spring.deserializer.key.function";
    public static final String VALUE_FUNCTION = "spring.deserializer.value.function";
    public static final String KEY_DESERIALIZER_CLASS = "spring.deserializer.key.delegate.class";
    public static final String VALUE_DESERIALIZER_CLASS = "spring.deserializer.value.delegate.class";
    private ExtendedDeserializer<T> delegate;
    private boolean isKey;
    private BiFunction<byte[], Headers, T> failedDeserializationFunction;

    public ErrorHandlingDeserializer2() {
    }

    public ErrorHandlingDeserializer2(Deserializer<T> delegate) {
        this.delegate = this.setupDelegate(delegate);
    }

    public void setFailedDeserializationFunction(BiFunction<byte[], Headers, T> failedDeserializationFunction) {
        this.failedDeserializationFunction = failedDeserializationFunction;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setKey(boolean isKey) {
        this.isKey = isKey;
    }

    public ErrorHandlingDeserializer2<T> keyDeserializer(boolean isKey) {
        this.isKey = isKey;
        return this;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.setupDelegate(configs, isKey ? KEY_DESERIALIZER_CLASS : VALUE_DESERIALIZER_CLASS);
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"No delegate deserializer configured");
        this.delegate.configure(configs, isKey);
        this.isKey = isKey;
        this.setupFunction(configs, isKey ? KEY_FUNCTION : VALUE_FUNCTION);
    }

    public void setupDelegate(Map<String, ?> configs, String configKey) {
        if (configs.containsKey(configKey)) {
            try {
                Object value = configs.get(configKey);
                Class clazz = value instanceof Class ? (Class)value : ClassUtils.forName((String)((String)value), null);
                this.delegate = this.setupDelegate(clazz.newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private ExtendedDeserializer<T> setupDelegate(Object delegate) {
        Assert.isInstanceOf(Deserializer.class, (Object)delegate, (String)"'delegate' must be a 'Deserializer', not a ");
        return delegate instanceof ExtendedDeserializer ? (ExtendedDeserializer)delegate : ExtendedDeserializer.Wrapper.ensureExtended((Deserializer)((Deserializer)delegate));
    }

    private void setupFunction(Map<String, ?> configs, String configKey) {
        if (configs.containsKey(configKey)) {
            try {
                Object value = configs.get(configKey);
                Class clazz = value instanceof Class ? (Class)value : ClassUtils.forName((String)((String)value), null);
                Assert.isTrue((boolean)BiFunction.class.isAssignableFrom(clazz), (String)("'function' must be a 'BiFunction\t', not a " + clazz.getName()));
                this.failedDeserializationFunction = (BiFunction)clazz.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public T deserialize(String topic, byte[] data) {
        try {
            return (T)this.delegate.deserialize(topic, data);
        }
        catch (Exception e) {
            return this.failedDeserializationFunction != null ? (T)this.failedDeserializationFunction.apply(data, null) : null;
        }
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        try {
            return (T)this.delegate.deserialize(topic, headers, data);
        }
        catch (Exception e) {
            this.deserializationException(headers, data, e);
            return this.failedDeserializationFunction != null ? (T)this.failedDeserializationFunction.apply(data, headers) : null;
        }
    }

    public void close() {
        this.delegate.close();
    }

    private void deserializationException(Headers headers, byte[] data, Exception e) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DeserializationException exception = new DeserializationException("failed to deserialize", data, this.isKey, e);
        try {
            new ObjectOutputStream(stream).writeObject((Object)exception);
        }
        catch (IOException ex) {
            try {
                exception = new DeserializationException("failed to deserialize", data, this.isKey, new RuntimeException("Could not deserialize type " + e.getClass().getName() + " with message " + e.getMessage() + " failure: " + ex.getMessage()));
                new ObjectOutputStream(stream).writeObject((Object)exception);
            }
            catch (IOException ex2) {
                throw new IllegalStateException("Could not serialize a DeserializationException", ex2);
            }
        }
        headers.add((Header)new RecordHeader(this.isKey ? KEY_DESERIALIZER_EXCEPTION_HEADER : VALUE_DESERIALIZER_EXCEPTION_HEADER, stream.toByteArray()));
    }
}

