/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.springframework.kafka.support.AbstractKafkaHeaderMapper;
import org.springframework.messaging.MessageHeaders;

public class SimpleKafkaHeaderMapper
extends AbstractKafkaHeaderMapper {
    public SimpleKafkaHeaderMapper() {
        super("!id", "!timestamp", "*");
    }

    public SimpleKafkaHeaderMapper(String ... patterns) {
        super(patterns);
    }

    @Override
    public void fromHeaders(MessageHeaders headers, Headers target) {
        headers.forEach((key, value) -> {
            Object valueToAdd;
            if (!key.equals("kafka_deliveryAttempt") && (valueToAdd = this.headerValueToAddOut((String)key, value)) instanceof byte[] && this.matches((String)key, valueToAdd)) {
                target.add((Header)new RecordHeader(key, (byte[])valueToAdd));
            }
        });
    }

    @Override
    public void toHeaders(Headers source, Map<String, Object> target) {
        source.forEach(header -> {
            if (header.key().equals("kafka_deliveryAttempt")) {
                target.put(header.key(), ByteBuffer.wrap(header.value()).getInt());
            } else {
                target.put(header.key(), this.headerValueToAddIn((Header)header));
            }
        });
    }
}

